/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.support;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ElasticsearchTimeoutException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.UnavailableShardsException;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.IndicesAdminClient;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.ProjectState;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.cluster.health.ClusterIndexHealth;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.metadata.ReservedStateMetadata;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.TriConsumer;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.features.FeatureService;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.indices.IndexClosedException;
import org.elasticsearch.indices.SystemIndexDescriptor;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.Scheduler;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.security.authz.RoleMappingMetadata;
import org.elasticsearch.xpack.security.SecurityFeatures;
import org.elasticsearch.xpack.security.support.SecurityMigrations;

public class SecurityIndexManager
implements ClusterStateListener {
    public static final String SECURITY_VERSION_STRING = "security-version";
    protected static final String FILE_SETTINGS_METADATA_NAMESPACE = "file_settings";
    private static final Logger logger = LogManager.getLogger(SecurityIndexManager.class);
    private final Client client;
    private final SystemIndexDescriptor systemIndexDescriptor;
    private final List<TriConsumer<ProjectId, IndexState, IndexState>> stateChangeListeners = new CopyOnWriteArrayList<TriConsumer<ProjectId, IndexState, IndexState>>();
    private final List<Consumer<SecurityIndexManager>> stateRecoveredListeners = new CopyOnWriteArrayList<Consumer<SecurityIndexManager>>();
    private volatile Map<ProjectId, IndexState> stateByProject;
    private final FeatureService featureService;
    private final ProjectResolver projectResolver;
    private final Set<NodeFeature> allSecurityFeatures = new SecurityFeatures().getFeatures();

    public static SecurityIndexManager buildSecurityIndexManager(Client client, ClusterService clusterService, FeatureService featureService, ProjectResolver projectResolver, SystemIndexDescriptor descriptor) {
        SecurityIndexManager securityIndexManager = new SecurityIndexManager(featureService, projectResolver, client, descriptor);
        clusterService.addListener((ClusterStateListener)securityIndexManager);
        return securityIndexManager;
    }

    private SecurityIndexManager(FeatureService featureService, ProjectResolver projectResolver, Client client, SystemIndexDescriptor descriptor) {
        this.featureService = featureService;
        this.projectResolver = projectResolver;
        this.client = client;
        this.systemIndexDescriptor = descriptor;
        this.stateByProject = null;
    }

    private IndexState unavailableState(ProjectId projectId, ProjectStatus status) {
        if (status == ProjectStatus.PROJECT_AVAILABLE) {
            throw new IllegalArgumentException("Unavailable status cannot be [" + String.valueOf((Object)status) + "]");
        }
        return new IndexState(projectId, status, null, false, false, false, false, false, null, false, null, null, null, null, null, null, null, Set.of());
    }

    public IndexState forCurrentProject() {
        return this.getProject(this.projectResolver.getProjectId());
    }

    public IndexState getProject(ProjectId project) {
        return this.getProjectState(project, this.stateByProject);
    }

    private IndexState getProjectState(ProjectId project, Map<ProjectId, IndexState> byProject) {
        if (byProject == null) {
            return this.unavailableState(project, ProjectStatus.CLUSTER_NOT_RECOVERED);
        }
        return Objects.requireNonNullElseGet(byProject.get(project), () -> this.unavailableState(project, ProjectStatus.PROJECT_DOES_NOT_EXIST));
    }

    public String aliasName() {
        return this.systemIndexDescriptor.getAliasName();
    }

    public void addStateListener(TriConsumer<ProjectId, IndexState, IndexState> listener) {
        this.stateChangeListeners.add(listener);
    }

    public void removeStateListener(TriConsumer<ProjectId, IndexState, IndexState> listener) {
        this.stateChangeListeners.remove(listener);
    }

    private SystemIndexDescriptor.MappingsVersion getMinSecurityIndexMappingVersion(ProjectState projectState) {
        SystemIndexDescriptor.MappingsVersion mappingsVersion = (SystemIndexDescriptor.MappingsVersion)projectState.cluster().getMinSystemIndexMappingVersions().get(this.systemIndexDescriptor.getPrimaryIndex());
        return mappingsVersion == null ? new SystemIndexDescriptor.MappingsVersion(1, 0) : mappingsVersion;
    }

    private static boolean isCreatedOnLatestVersion(IndexMetadata indexMetadata) {
        IndexVersion indexVersionCreated = indexMetadata != null ? (IndexVersion)IndexMetadata.SETTING_INDEX_VERSION_CREATED.get(indexMetadata.getSettings()) : null;
        return indexVersionCreated != null && indexVersionCreated.onOrAfter((VersionId)IndexVersion.current());
    }

    static RoleMappingsCleanupMigrationStatus getRoleMappingsCleanupMigrationStatus(ProjectState projectState, int migrationsVersion) {
        boolean hasFileSettingsMetadata;
        if (migrationsVersion >= SecurityMigrations.CLEANUP_ROLE_MAPPING_DUPLICATES_MIGRATION_VERSION) {
            return RoleMappingsCleanupMigrationStatus.DONE;
        }
        ReservedStateMetadata fileSettingsMetadata = (ReservedStateMetadata)projectState.cluster().metadata().reservedStateMetadata().get(FILE_SETTINGS_METADATA_NAMESPACE);
        boolean bl = hasFileSettingsMetadata = fileSettingsMetadata != null;
        assert (hasFileSettingsMetadata || projectState.cluster().metadata().reservedStateMetadata().isEmpty()) : "ReservedStateMetadata contains unknown namespace";
        if (!hasFileSettingsMetadata || fileSettingsMetadata.keys("role_mappings").isEmpty()) {
            return RoleMappingsCleanupMigrationStatus.SKIP;
        }
        RoleMappingMetadata roleMappingMetadata = RoleMappingMetadata.getFromProject((ProjectMetadata)projectState.metadata());
        if (roleMappingMetadata.getRoleMappings().size() == fileSettingsMetadata.keys("role_mappings").size() && !roleMappingMetadata.hasAnyMappingWithFallbackName()) {
            return RoleMappingsCleanupMigrationStatus.READY;
        }
        return RoleMappingsCleanupMigrationStatus.NOT_READY;
    }

    public void clusterChanged(ClusterChangedEvent event) {
        ClusterState clusterState = event.state();
        if (clusterState.blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
            logger.debug("security index manager waiting until state has been recovered");
            return;
        }
        Map<ProjectId, IndexState> previousStateByProject = this.stateByProject;
        ArrayList<Runnable> notifications = new ArrayList<Runnable>();
        if (previousStateByProject == null) {
            this.stateRecoveredListeners.forEach(listener -> notifications.add(() -> {
                listener.accept(this);
                this.stateRecoveredListeners.remove(listener);
            }));
        }
        Map newStateByProject = Maps.newMapWithExpectedSize((int)clusterState.metadata().projects().size());
        for (ProjectId projectId : clusterState.metadata().projects().keySet()) {
            IndexState previousState = this.getProjectState(projectId, previousStateByProject);
            IndexState newState = this.updateProjectState(clusterState.projectState(projectId));
            if (!newState.equals(previousState)) {
                notifications.add(() -> {
                    for (TriConsumer<ProjectId, IndexState, IndexState> listener : this.stateChangeListeners) {
                        listener.apply((Object)projectId, (Object)previousState, (Object)newState);
                    }
                });
            }
            newStateByProject.put(projectId, newState);
        }
        if (previousStateByProject != null) {
            for (ProjectId projectId : previousStateByProject.keySet()) {
                if (newStateByProject.containsKey(projectId)) continue;
                notifications.add(() -> {
                    for (TriConsumer<ProjectId, IndexState, IndexState> listener : this.stateChangeListeners) {
                        listener.apply((Object)projectId, (Object)((IndexState)previousStateByProject.get(projectId)), (Object)this.unavailableState(projectId, ProjectStatus.PROJECT_DOES_NOT_EXIST));
                    }
                });
            }
        }
        this.stateByProject = Collections.unmodifiableMap(newStateByProject);
        notifications.forEach(Runnable::run);
    }

    private IndexState updateProjectState(ProjectState project) {
        ClusterHealthStatus indexHealth;
        IndexMetadata.State indexState;
        String concreteIndexName;
        IndexMetadata indexMetadata = SecurityIndexManager.resolveConcreteIndex(this.systemIndexDescriptor.getAliasName(), project.metadata());
        boolean createdOnLatestVersion = SecurityIndexManager.isCreatedOnLatestVersion(indexMetadata);
        Instant creationTime = indexMetadata != null ? Instant.ofEpochMilli(indexMetadata.getCreationDate()) : null;
        boolean isIndexUpToDate = indexMetadata == null || ((Integer)IndexMetadata.INDEX_FORMAT_SETTING.get(indexMetadata.getSettings())).intValue() == this.systemIndexDescriptor.getIndexFormat();
        Tuple<Boolean, Boolean> available = this.checkIndexAvailable(project);
        boolean indexAvailableForWrite = (Boolean)available.v1();
        boolean indexAvailableForSearch = (Boolean)available.v2();
        int migrationsVersion = SecurityIndexManager.getMigrationVersionFromIndexMetadata(indexMetadata);
        RoleMappingsCleanupMigrationStatus roleMappingsCleanupMigrationStatus = SecurityIndexManager.getRoleMappingsCleanupMigrationStatus(project, migrationsVersion);
        PersistentTasksCustomMetadata persistentTaskCustomMetadata = PersistentTasksCustomMetadata.get((ProjectMetadata)project.metadata());
        boolean securityMigrationRunning = persistentTaskCustomMetadata != null && persistentTaskCustomMetadata.getTask("security-migration") != null;
        boolean mappingIsUpToDate = indexMetadata == null || this.checkIndexMappingUpToDate(project);
        SystemIndexDescriptor.MappingsVersion minClusterMappingVersion = this.getMinSecurityIndexMappingVersion(project);
        int indexMappingVersion = SecurityIndexManager.loadIndexMappingVersion(this.systemIndexDescriptor.getAliasName(), project.metadata());
        String string = concreteIndexName = indexMetadata == null ? this.systemIndexDescriptor.getPrimaryIndex() : indexMetadata.getIndex().getName();
        if (indexMetadata == null) {
            indexState = null;
            indexHealth = null;
        } else if (indexMetadata.getState() == IndexMetadata.State.CLOSE) {
            indexState = IndexMetadata.State.CLOSE;
            indexHealth = null;
            logger.warn("Index [{}] is closed. This is likely to prevent security from functioning correctly", (Object)concreteIndexName);
        } else {
            indexState = IndexMetadata.State.OPEN;
            IndexRoutingTable routingTable = project.routingTable().index(indexMetadata.getIndex());
            indexHealth = new ClusterIndexHealth(indexMetadata, routingTable).getStatus();
        }
        String indexUUID = indexMetadata != null ? indexMetadata.getIndexUUID() : null;
        IndexState newState = new IndexState(project.projectId(), ProjectStatus.PROJECT_AVAILABLE, creationTime, isIndexUpToDate, indexAvailableForSearch, indexAvailableForWrite, mappingIsUpToDate, createdOnLatestVersion, roleMappingsCleanupMigrationStatus, securityMigrationRunning, migrationsVersion, minClusterMappingVersion, indexMappingVersion, concreteIndexName, indexHealth, indexState, indexUUID, this.allSecurityFeatures.stream().filter(feature -> this.featureService.clusterHasFeature(project.cluster(), feature)).collect(Collectors.toSet()));
        return newState;
    }

    public static int getMigrationVersionFromIndexMetadata(IndexMetadata indexMetadata) {
        Map customMetadata;
        Map map = customMetadata = indexMetadata == null ? null : indexMetadata.getCustomData("migration_version");
        if (customMetadata == null) {
            return 0;
        }
        String migrationVersion = (String)customMetadata.get("version");
        return migrationVersion == null ? 0 : Integer.parseInt(migrationVersion);
    }

    public void whenProjectStateAvailable(final ProjectId targetProject, final Consumer<IndexState> stateConsumer) {
        TriConsumer<ProjectId, IndexState, IndexState> stateChangeListener = new TriConsumer<ProjectId, IndexState, IndexState>(){

            public void apply(ProjectId projectId, IndexState previousState, IndexState nextState) {
                if (!projectId.equals((Object)targetProject)) {
                    return;
                }
                if (nextState.isProjectAvailable()) {
                    SecurityIndexManager.this.stateChangeListeners.remove(this);
                    stateConsumer.accept(nextState);
                }
            }
        };
        this.stateChangeListeners.add(stateChangeListener);
    }

    List<TriConsumer<ProjectId, IndexState, IndexState>> getStateChangeListeners() {
        return this.stateChangeListeners;
    }

    private Tuple<Boolean, Boolean> checkIndexAvailable(ProjectState project) {
        String aliasName = this.systemIndexDescriptor.getAliasName();
        IndexMetadata metadata = SecurityIndexManager.resolveConcreteIndex(aliasName, project.metadata());
        if (metadata == null) {
            logger.debug("Index [{}] is not available in project [{}] - no metadata", (Object)aliasName, (Object)project.projectId());
            return new Tuple((Object)false, (Object)false);
        }
        if (metadata.getState() == IndexMetadata.State.CLOSE) {
            logger.warn("Index [{}] is closed in project [{}]", (Object)aliasName, (Object)project.projectId());
            return new Tuple((Object)false, (Object)false);
        }
        boolean allPrimaryShards = false;
        boolean searchShards = false;
        IndexRoutingTable routingTable = project.routingTable().index(metadata.getIndex());
        if (routingTable != null && routingTable.allPrimaryShardsActive()) {
            allPrimaryShards = true;
        }
        if (routingTable != null && routingTable.readyForSearch()) {
            searchShards = true;
        }
        if (!allPrimaryShards || !searchShards) {
            logger.debug("Index [{}] is not fully available in project [{}]. all primary shards available [{}], search shards available, [{}]", (Object)aliasName, (Object)project.projectId(), (Object)allPrimaryShards, (Object)searchShards);
        }
        return new Tuple((Object)allPrimaryShards, (Object)searchShards);
    }

    private boolean checkIndexMappingUpToDate(ProjectState projectState) {
        SystemIndexDescriptor descriptor = this.systemIndexDescriptor.getDescriptorCompatibleWith(this.getMinSecurityIndexMappingVersion(projectState));
        if (descriptor == null) {
            return false;
        }
        return descriptor.getMappingsVersion().version() <= SecurityIndexManager.loadIndexMappingVersion(this.systemIndexDescriptor.getAliasName(), projectState.metadata());
    }

    private static int loadIndexMappingVersion(String aliasName, ProjectMetadata projectMetadata) {
        MappingMetadata mappingMetadata;
        IndexMetadata indexMetadata = SecurityIndexManager.resolveConcreteIndex(aliasName, projectMetadata);
        if (indexMetadata != null && (mappingMetadata = indexMetadata.mapping()) != null) {
            return SecurityIndexManager.readMappingVersion(aliasName, mappingMetadata);
        }
        return 0;
    }

    private static int readMappingVersion(String indexName, MappingMetadata mappingMetadata) {
        Map meta = (Map)mappingMetadata.sourceAsMap().get("_meta");
        if (meta == null) {
            logger.info("Missing _meta field in mapping [{}] of index [{}]", (Object)mappingMetadata.type(), (Object)indexName);
            throw new IllegalStateException("Cannot read managed_index_mappings_version string in index " + indexName);
        }
        Integer value = (Integer)meta.get("managed_index_mappings_version");
        return value == null ? 0 : value;
    }

    public static IndexMetadata resolveConcreteIndex(String indexOrAliasName, ProjectMetadata project) {
        IndexAbstraction indexAbstraction = (IndexAbstraction)project.getIndicesLookup().get(indexOrAliasName);
        if (indexAbstraction != null) {
            List indices = indexAbstraction.getIndices();
            if (indexAbstraction.getType() != IndexAbstraction.Type.CONCRETE_INDEX && indices.size() > 1) {
                throw new IllegalStateException("Alias [" + indexOrAliasName + "] points to more than one index: " + String.valueOf(indices));
            }
            return project.index((Index)indices.get(0));
        }
        return null;
    }

    public static boolean isMoveFromRedToNonRed(IndexState previousState, IndexState currentState) {
        return (previousState.indexHealth == null || previousState.indexHealth == ClusterHealthStatus.RED) && currentState.indexHealth != null && currentState.indexHealth != ClusterHealthStatus.RED;
    }

    public static boolean isIndexDeleted(IndexState previousState, IndexState currentState) {
        return previousState.indexHealth != null && currentState.indexHealth == null;
    }

    public static enum ProjectStatus {
        CLUSTER_NOT_RECOVERED,
        PROJECT_DOES_NOT_EXIST,
        PROJECT_AVAILABLE;

    }

    public class IndexState {
        private final ProjectId projectId;
        private final ProjectStatus projectStatus;
        public final Instant creationTime;
        public final boolean isIndexUpToDate;
        public final boolean indexAvailableForSearch;
        public final boolean indexAvailableForWrite;
        public final boolean mappingUpToDate;
        public final boolean createdOnLatestVersion;
        public final RoleMappingsCleanupMigrationStatus roleMappingsCleanupMigrationStatus;
        public final boolean securityMigrationRunning;
        public final Integer migrationsVersion;
        public final SystemIndexDescriptor.MappingsVersion minClusterMappingVersion;
        public final Integer indexMappingVersion;
        public final String concreteIndexName;
        public final ClusterHealthStatus indexHealth;
        public final IndexMetadata.State indexState;
        public final String indexUUID;
        public final Set<NodeFeature> securityFeatures;

        public IndexState(ProjectId projectId, ProjectStatus projectStatus, Instant creationTime, boolean isIndexUpToDate, boolean indexAvailableForSearch, boolean indexAvailableForWrite, boolean mappingUpToDate, boolean createdOnLatestVersion, RoleMappingsCleanupMigrationStatus roleMappingsCleanupMigrationStatus, boolean securityMigrationRunning, Integer migrationsVersion, SystemIndexDescriptor.MappingsVersion minClusterMappingVersion, Integer indexMappingVersion, String concreteIndexName, ClusterHealthStatus indexHealth, IndexMetadata.State indexState, String indexUUID, Set<NodeFeature> securityFeatures) {
            this.projectId = projectId;
            this.projectStatus = projectStatus;
            this.creationTime = creationTime;
            this.isIndexUpToDate = isIndexUpToDate;
            this.indexAvailableForSearch = indexAvailableForSearch;
            this.indexAvailableForWrite = indexAvailableForWrite;
            this.mappingUpToDate = mappingUpToDate;
            this.migrationsVersion = migrationsVersion;
            this.createdOnLatestVersion = createdOnLatestVersion;
            this.roleMappingsCleanupMigrationStatus = roleMappingsCleanupMigrationStatus;
            this.securityMigrationRunning = securityMigrationRunning;
            this.minClusterMappingVersion = minClusterMappingVersion;
            this.indexMappingVersion = indexMappingVersion;
            this.concreteIndexName = concreteIndexName;
            this.indexHealth = indexHealth;
            this.indexState = indexState;
            this.indexUUID = indexUUID;
            this.securityFeatures = securityFeatures;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IndexState other = (IndexState)o;
            return Objects.equals(this.projectId, other.projectId) && Objects.equals((Object)this.projectStatus, (Object)other.projectStatus) && Objects.equals(this.creationTime, other.creationTime) && this.isIndexUpToDate == other.isIndexUpToDate && this.indexAvailableForSearch == other.indexAvailableForSearch && this.indexAvailableForWrite == other.indexAvailableForWrite && this.mappingUpToDate == other.mappingUpToDate && this.createdOnLatestVersion == other.createdOnLatestVersion && this.roleMappingsCleanupMigrationStatus == other.roleMappingsCleanupMigrationStatus && this.securityMigrationRunning == other.securityMigrationRunning && Objects.equals(this.indexMappingVersion, other.indexMappingVersion) && Objects.equals(this.migrationsVersion, other.migrationsVersion) && Objects.equals(this.minClusterMappingVersion, other.minClusterMappingVersion) && Objects.equals(this.concreteIndexName, other.concreteIndexName) && this.indexHealth == other.indexHealth && this.indexState == other.indexState && Objects.equals(this.securityFeatures, other.securityFeatures);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.projectId, this.projectStatus, this.creationTime, this.isIndexUpToDate, this.indexAvailableForSearch, this.indexAvailableForWrite, this.mappingUpToDate, this.createdOnLatestVersion, this.roleMappingsCleanupMigrationStatus, this.securityMigrationRunning, this.migrationsVersion, this.minClusterMappingVersion, this.indexMappingVersion, this.concreteIndexName, this.indexHealth, this.securityFeatures});
        }

        public String aliasName() {
            return SecurityIndexManager.this.aliasName();
        }

        public boolean indexExists() {
            return this.creationTime != null;
        }

        public boolean indexIsClosed() {
            return this.indexState == IndexMetadata.State.CLOSE;
        }

        public Instant getCreationTime() {
            return this.creationTime;
        }

        public boolean isIndexUpToDate() {
            return this.isIndexUpToDate;
        }

        public boolean isAvailable(Availability availability) {
            switch (availability.ordinal()) {
                case 0: {
                    return this.indexAvailableForSearch;
                }
                case 1: {
                    return this.indexAvailableForWrite;
                }
            }
            throw new IllegalStateException("Unexpected availability enumeration. This is bug, please contact support.");
        }

        public boolean isMappingUpToDate() {
            return this.mappingUpToDate;
        }

        boolean isProjectAvailable() {
            return this.projectStatus == ProjectStatus.PROJECT_AVAILABLE;
        }

        boolean isClusterStateRecovered() {
            return this.projectStatus != ProjectStatus.CLUSTER_NOT_RECOVERED;
        }

        public boolean isMigrationsVersionAtLeast(Integer expectedMigrationsVersion) {
            return this.indexExists() && this.migrationsVersion.compareTo(expectedMigrationsVersion) >= 0;
        }

        public boolean isCreatedOnLatestVersion() {
            return this.createdOnLatestVersion;
        }

        public String getConcreteIndexName() {
            return this.concreteIndexName;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{projectId=" + String.valueOf(this.projectId) + ", creationTime=" + String.valueOf(this.creationTime) + ", isIndexUpToDate=" + this.isIndexUpToDate + ", indexAvailableForSearch=" + this.indexAvailableForSearch + ", indexAvailableForWrite=" + this.indexAvailableForWrite + ", mappingUpToDate=" + this.mappingUpToDate + ", createdOnLatestVersion=" + this.createdOnLatestVersion + ", roleMappingsCleanupMigrationStatus=" + String.valueOf((Object)this.roleMappingsCleanupMigrationStatus) + ", securityMigrationRunning=" + this.securityMigrationRunning + ", migrationsVersion=" + this.migrationsVersion + ", minClusterMappingVersion=" + String.valueOf(this.minClusterMappingVersion) + ", indexMappingVersion=" + this.indexMappingVersion + ", concreteIndexName='" + this.concreteIndexName + "', indexHealth=" + String.valueOf(this.indexHealth) + ", indexState=" + String.valueOf(this.indexState) + ", indexUUID='" + this.indexUUID + "', securityFeatures=" + String.valueOf(this.securityFeatures) + "}";
        }

        public ElasticsearchException getUnavailableReason(Availability availability) {
            if (this.indexState == IndexMetadata.State.CLOSE) {
                return new IndexClosedException(new Index(this.concreteIndexName, "_na_"));
            }
            if (this.indexExists()) {
                assert (!this.indexAvailableForSearch || !this.indexAvailableForWrite);
                if (Availability.PRIMARY_SHARDS.equals((Object)availability) && !this.indexAvailableForWrite) {
                    return new UnavailableShardsException(null, "at least one primary shard for the index [" + this.concreteIndexName + "] is unavailable", new Object[0]);
                }
                if (Availability.SEARCH_SHARDS.equals((Object)availability) && !this.indexAvailableForSearch) {
                    return new UnavailableShardsException(null, "at least one search shard for the index [" + this.concreteIndexName + "] is unavailable", new Object[0]);
                }
                throw new IllegalStateException("caller must ensure original availability matches the current availability");
            }
            return new IndexNotFoundException(this.concreteIndexName);
        }

        public void checkIndexVersionThenExecute(Consumer<Exception> consumer, Runnable andThen) {
            if (this.indexExists() && !this.isIndexUpToDate) {
                consumer.accept(new IllegalStateException("Index [" + this.concreteIndexName + "] is not on the current version. Security features relying on the index will not be available until the upgrade API is run on the index"));
            } else {
                andThen.run();
            }
        }

        public void prepareIndexIfNeededThenExecute(final Consumer<Exception> consumer, final Runnable andThen) {
            try {
                if (this.projectStatus == ProjectStatus.CLUSTER_NOT_RECOVERED) {
                    throw new ElasticsearchStatusException("Cluster state has not been recovered yet, cannot write to the [" + this.concreteIndexName + "] index", RestStatus.SERVICE_UNAVAILABLE, new Object[0]);
                }
                if (this.projectStatus == ProjectStatus.PROJECT_DOES_NOT_EXIST) {
                    throw new ElasticsearchStatusException("Project [" + String.valueOf(this.projectId) + "] is not available in cluster state, cannot write to the [" + this.concreteIndexName + "] index", RestStatus.SERVICE_UNAVAILABLE, new Object[0]);
                }
                if (this.indexExists() && !this.isIndexUpToDate) {
                    throw new IllegalStateException("Index [" + this.concreteIndexName + "] is not on the current version.Security features relying on the index will not be available until the upgrade API is run on the index");
                }
                if (!this.indexExists()) {
                    assert (this.concreteIndexName != null);
                    SystemIndexDescriptor descriptorForVersion = SecurityIndexManager.this.systemIndexDescriptor.getDescriptorCompatibleWith(this.minClusterMappingVersion);
                    if (descriptorForVersion == null) {
                        String error = SecurityIndexManager.this.systemIndexDescriptor.getMinimumMappingsVersionMessage("create index", this.minClusterMappingVersion);
                        consumer.accept(new IllegalStateException(error));
                    } else {
                        logger.info("security index does not exist, creating [{}] with alias [{}]", (Object)this.concreteIndexName, (Object)descriptorForVersion.getAliasName());
                        CreateIndexRequest request = new CreateIndexRequest(this.concreteIndexName).origin(descriptorForVersion.getOrigin()).mapping(descriptorForVersion.getMappings()).settings(descriptorForVersion.getSettings()).alias(new Alias(descriptorForVersion.getAliasName())).waitForActiveShards(ActiveShardCount.ALL);
                        ClientHelper.executeAsyncWithOrigin((ThreadContext)SecurityIndexManager.this.client.threadPool().getThreadContext(), (String)descriptorForVersion.getOrigin(), (Object)request, (ActionListener)new ActionListener<CreateIndexResponse>(){

                            public void onResponse(CreateIndexResponse createIndexResponse) {
                                if (createIndexResponse.isAcknowledged()) {
                                    andThen.run();
                                } else {
                                    consumer.accept(new ElasticsearchException("Failed to create security index", new Object[0]));
                                }
                            }

                            public void onFailure(Exception e) {
                                Throwable cause = ExceptionsHelper.unwrapCause((Throwable)e);
                                if (cause instanceof ResourceAlreadyExistsException) {
                                    andThen.run();
                                } else {
                                    consumer.accept(e);
                                }
                            }
                        }, (arg_0, arg_1) -> ((IndicesAdminClient)SecurityIndexManager.this.client.admin().indices()).create(arg_0, arg_1));
                    }
                } else if (!this.mappingUpToDate) {
                    SystemIndexDescriptor descriptorForVersion = SecurityIndexManager.this.systemIndexDescriptor.getDescriptorCompatibleWith(this.minClusterMappingVersion);
                    if (descriptorForVersion == null) {
                        String error = SecurityIndexManager.this.systemIndexDescriptor.getMinimumMappingsVersionMessage("updating mapping", this.minClusterMappingVersion);
                        consumer.accept(new IllegalStateException(error));
                    } else {
                        logger.info("Index [{}] (alias [{}]) is not up to date. Updating mapping", (Object)this.concreteIndexName, (Object)descriptorForVersion.getAliasName());
                        PutMappingRequest request = new PutMappingRequest(new String[]{this.concreteIndexName}).source(descriptorForVersion.getMappings(), XContentType.JSON).origin(descriptorForVersion.getOrigin());
                        ClientHelper.executeAsyncWithOrigin((ThreadContext)SecurityIndexManager.this.client.threadPool().getThreadContext(), (String)descriptorForVersion.getOrigin(), (Object)request, (ActionListener)ActionListener.wrap(putMappingResponse -> {
                            if (putMappingResponse.isAcknowledged()) {
                                andThen.run();
                            } else {
                                consumer.accept(new IllegalStateException("put mapping request was not acknowledged"));
                            }
                        }, consumer), (arg_0, arg_1) -> ((IndicesAdminClient)SecurityIndexManager.this.client.admin().indices()).putMapping(arg_0, arg_1));
                    }
                } else {
                    andThen.run();
                }
            }
            catch (Exception e) {
                consumer.accept(e);
            }
        }

        public RoleMappingsCleanupMigrationStatus getRoleMappingsCleanupMigrationStatus() {
            return this.roleMappingsCleanupMigrationStatus;
        }

        public boolean isEligibleSecurityMigration(SecurityMigrations.SecurityMigration securityMigration) {
            return this.securityFeatures.containsAll(securityMigration.nodeFeaturesRequired()) && this.indexMappingVersion >= securityMigration.minMappingVersion() && securityMigration.checkPreConditions(this);
        }

        public boolean isReadyForSecurityMigration(SecurityMigrations.SecurityMigration securityMigration) {
            return this.indexAvailableForWrite && this.indexAvailableForSearch && this.isIndexUpToDate && this.indexExists() && this.isEligibleSecurityMigration(securityMigration);
        }

        public void onIndexAvailableForSearch(final ActionListener<Void> listener, TimeValue timeout) {
            logger.info("Will wait for security index [{}] in project [{}] for [{}] to become available for search", (Object)this.getConcreteIndexName(), (Object)this.projectId, (Object)timeout);
            if (this.indexAvailableForSearch) {
                logger.debug("Security index [{}] in [{}] is already available", (Object)this.getConcreteIndexName(), (Object)this.projectId);
                listener.onResponse(null);
                return;
            }
            final AtomicBoolean isDone = new AtomicBoolean(false);
            StateConsumerWithCancellable indexAvailableForSearchListener = new StateConsumerWithCancellable(){

                public void apply(ProjectId eventProjectId, IndexState previousState, IndexState nextState) {
                    if (eventProjectId.equals((Object)IndexState.this.projectId) && nextState.indexAvailableForSearch && isDone.compareAndSet(false, true)) {
                        this.cancel();
                        SecurityIndexManager.this.removeStateListener(this);
                        listener.onResponse(null);
                    }
                }
            };
            SecurityIndexManager.this.addStateListener(indexAvailableForSearchListener);
            indexAvailableForSearchListener.setCancellable(SecurityIndexManager.this.client.threadPool().schedule(() -> this.lambda$onIndexAvailableForSearch$1(isDone, indexAvailableForSearchListener, listener), timeout, (Executor)SecurityIndexManager.this.client.threadPool().generic()));
        }

        private /* synthetic */ void lambda$onIndexAvailableForSearch$1(AtomicBoolean isDone, 2 indexAvailableForSearchListener, ActionListener listener) {
            if (isDone.compareAndSet(false, true)) {
                SecurityIndexManager.this.removeStateListener(indexAvailableForSearchListener);
                listener.onFailure((Exception)new ElasticsearchTimeoutException("timed out waiting for security index [" + this.getConcreteIndexName() + "] to become available for search", new Object[0]));
            }
        }
    }

    public static enum RoleMappingsCleanupMigrationStatus {
        READY,
        NOT_READY,
        SKIP,
        DONE;

    }

    static abstract class StateConsumerWithCancellable
    implements TriConsumer<ProjectId, IndexState, IndexState>,
    Scheduler.Cancellable {
        private volatile Scheduler.ScheduledCancellable cancellable;
        private volatile boolean cancelled = false;

        StateConsumerWithCancellable() {
        }

        void setCancellable(Scheduler.ScheduledCancellable cancellable) {
            this.cancellable = cancellable;
            if (this.cancelled) {
                this.cancel();
            }
        }

        public boolean cancel() {
            this.cancelled = true;
            if (this.cancellable != null) {
                return this.cancellable.cancel();
            }
            return this.isCancelled();
        }

        public boolean isCancelled() {
            return this.cancelled;
        }
    }

    public static enum Availability {
        SEARCH_SHARDS,
        PRIMARY_SHARDS;

    }
}

