/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.esnative.tool;

import java.net.URL;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Function;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.cli.UserException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.KeyStoreWrapper;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.env.Environment;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.json.JsonXContent;
import org.elasticsearch.xpack.core.security.CommandLineHttpClient;
import org.elasticsearch.xpack.core.security.HttpResponse;
import org.elasticsearch.xpack.core.security.support.Validation;
import org.elasticsearch.xpack.security.tool.BaseRunAsSuperuserCommand;
import org.elasticsearch.xpack.security.tool.CommandUtils;

class ResetPasswordTool
extends BaseRunAsSuperuserCommand {
    private final Function<Environment, CommandLineHttpClient> clientFunction;
    private final OptionSpecBuilder interactive;
    private final OptionSpecBuilder auto;
    private final OptionSpecBuilder batch;
    private final OptionSpec<String> usernameOption;

    ResetPasswordTool() {
        this(CommandLineHttpClient::new, (CheckedFunction<Environment, KeyStoreWrapper, Exception>)((CheckedFunction)environment -> KeyStoreWrapper.load((Path)environment.configDir())));
    }

    protected ResetPasswordTool(Function<Environment, CommandLineHttpClient> clientFunction, CheckedFunction<Environment, KeyStoreWrapper, Exception> keyStoreFunction) {
        super(clientFunction, keyStoreFunction, "Resets the password of users in the native realm and built-in users.");
        this.interactive = this.parser.acceptsAll(List.of("i", "interactive"));
        this.auto = this.parser.acceptsAll(List.of("a", "auto"));
        this.batch = this.parser.acceptsAll(List.of("b", "batch"));
        this.usernameOption = this.parser.acceptsAll(List.of("u", "username"), "The username of the user whose password will be reset").withRequiredArg().required();
        this.clientFunction = clientFunction;
    }

    @Override
    protected void executeCommand(Terminal terminal, OptionSet options, Environment env, String username, SecureString password) throws Exception {
        SecureString builtinUserPassword;
        String providedUsername = (String)options.valueOf(this.usernameOption);
        if (options.has((OptionSpec)this.interactive)) {
            if (!options.has((OptionSpec)this.batch)) {
                terminal.println((CharSequence)("This tool will reset the password of the [" + providedUsername + "] user."));
                terminal.println((CharSequence)"You will be prompted to enter the password.");
                shouldContinue = terminal.promptYesNo("Please confirm that you would like to continue", false);
                terminal.println((CharSequence)"\n");
                if (!shouldContinue) {
                    throw new UserException(0, "User cancelled operation");
                }
            }
            builtinUserPassword = ResetPasswordTool.promptForPassword(terminal, providedUsername);
        } else {
            if (!options.has((OptionSpec)this.batch)) {
                terminal.println((CharSequence)("This tool will reset the password of the [" + providedUsername + "] user to an autogenerated value."));
                terminal.println((CharSequence)"The password will be printed in the console.");
                shouldContinue = terminal.promptYesNo("Please confirm that you would like to continue", false);
                terminal.println((CharSequence)"\n");
                if (!shouldContinue) {
                    throw new UserException(0, "User cancelled operation");
                }
            }
            builtinUserPassword = new SecureString(CommandUtils.generatePassword(20));
        }
        try {
            CommandLineHttpClient client = this.clientFunction.apply(env);
            URL baseUrl = options.has(this.urlOption) ? new URL((String)options.valueOf(this.urlOption)) : new URL(client.getDefaultURL());
            URL changePasswordUrl = CommandLineHttpClient.createURL((URL)baseUrl, (String)("_security/user/" + providedUsername + "/_password"), (String)"?pretty");
            HttpResponse httpResponse = client.execute("POST", changePasswordUrl, username, password, () -> ResetPasswordTool.requestBodySupplier(builtinUserPassword), CommandLineHttpClient::responseBuilder);
            int responseStatus = httpResponse.getHttpStatus();
            if (httpResponse.getHttpStatus() != 200) {
                String cause = CommandLineHttpClient.getErrorCause((HttpResponse)httpResponse);
                String message = "Failed to reset password for the [" + providedUsername + "] user. Unexpected http status [" + responseStatus + "].";
                if (null != cause) {
                    message = message + " Cause was " + cause;
                }
                throw new UserException(75, message);
            }
            if (options.has((OptionSpec)this.interactive)) {
                terminal.println((CharSequence)("Password for the [" + providedUsername + "] user successfully reset."));
            } else {
                terminal.println((CharSequence)("Password for the [" + providedUsername + "] user successfully reset."));
                terminal.print(Terminal.Verbosity.NORMAL, "New value: ");
                terminal.println(Terminal.Verbosity.SILENT, (CharSequence)builtinUserPassword.toString());
            }
        }
        catch (Exception e) {
            throw new UserException(75, "Failed to reset password for the [" + providedUsername + "] user", (Throwable)e);
        }
        finally {
            builtinUserPassword.close();
        }
    }

    private static SecureString promptForPassword(Terminal terminal, String providedUsername) {
        SecureString password1;
        while (true) {
            Validation.Error err;
            if ((err = Validation.Users.validatePassword((SecureString)(password1 = new SecureString(terminal.readSecret("Enter password for [" + providedUsername + "]: "))))) != null) {
                terminal.errorPrintln(err.toString());
                terminal.errorPrintln("Try again.");
                password1.close();
                continue;
            }
            SecureString password2 = new SecureString(terminal.readSecret("Re-enter password for [" + providedUsername + "]: "));
            try {
                if (password1.equals((Object)password2)) break;
                terminal.errorPrintln("Passwords do not match.");
                terminal.errorPrintln("Try again.");
                password1.close();
                continue;
            }
            finally {
                password2.close();
                continue;
            }
            break;
        }
        return password1;
    }

    private static String requestBodySupplier(SecureString pwd) throws Exception {
        XContentBuilder xContentBuilder = JsonXContent.contentBuilder();
        xContentBuilder.startObject().field("password", pwd.toString()).endObject();
        return Strings.toString((XContentBuilder)xContentBuilder);
    }

    @Override
    protected void validate(Terminal terminal, OptionSet options, Environment env) throws Exception {
        if ((options.has("i") || options.has("interactive")) && (options.has("a") || options.has("auto"))) {
            throw new UserException(64, "You can only run the tool in one of [auto] or [interactive] modes");
        }
    }
}

