/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import org.elasticsearch.gradle.DistributionDependency;
import org.elasticsearch.gradle.DistributionResolution;
import org.elasticsearch.gradle.ElasticsearchDistribution;
import org.elasticsearch.gradle.Version;
import org.elasticsearch.gradle.distribution.ElasticsearchDistributionTypes;
import org.elasticsearch.gradle.transform.SymbolicLinkPreservingUntarTransform;
import org.elasticsearch.gradle.transform.UnzipTransform;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.artifacts.repositories.IvyArtifactRepository;
import org.gradle.api.artifacts.type.ArtifactTypeDefinition;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;

public class DistributionDownloadPlugin
implements Plugin<Project> {
    static final String RESOLUTION_CONTAINER_NAME = "elasticsearch_distributions_resolutions";
    private static final String CONTAINER_NAME = "elasticsearch_distributions";
    private static final String FAKE_IVY_GROUP = "elasticsearch-distribution";
    private static final String FAKE_SNAPSHOT_IVY_GROUP = "elasticsearch-distribution-snapshot";
    private static final String DOWNLOAD_REPO_NAME = "elasticsearch-downloads";
    private static final String SNAPSHOT_REPO_NAME = "elasticsearch-snapshots";
    public static final String ES_DISTRO_CONFIG_PREFIX = "es_distro_";
    public static final String DISTRO_EXTRACTED_CONFIG_PREFIX = "es_distro_extracted_";
    public static final String DISTRO_CONFIG_PREFIX = "es_distro_file_";
    private final ObjectFactory objectFactory;
    private NamedDomainObjectContainer<ElasticsearchDistribution> distributionsContainer;
    private List<DistributionResolution> distributionsResolutionStrategies;
    private Property<Boolean> dockerAvailability;
    private boolean writingDependencies = false;

    @Inject
    public DistributionDownloadPlugin(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
        this.dockerAvailability = objectFactory.property(Boolean.class).value((Object)false);
    }

    public void setDockerAvailability(Provider<Boolean> dockerAvailability) {
        this.dockerAvailability.set(dockerAvailability);
    }

    public void apply(Project project) {
        this.writingDependencies = !project.getGradle().getStartParameter().getWriteDependencyVerifications().isEmpty();
        project.getDependencies().registerTransform(UnzipTransform.class, transformSpec -> {
            transformSpec.getFrom().attribute(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, (Object)"zip");
            transformSpec.getTo().attribute(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, (Object)"directory");
        });
        ArtifactTypeDefinition tarArtifactTypeDefinition = (ArtifactTypeDefinition)project.getDependencies().getArtifactTypes().maybeCreate("tar.gz");
        project.getDependencies().registerTransform(SymbolicLinkPreservingUntarTransform.class, transformSpec -> {
            transformSpec.getFrom().attribute(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, (Object)tarArtifactTypeDefinition.getName());
            transformSpec.getTo().attribute(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, (Object)"directory");
        });
        this.setupResolutionsContainer(project);
        this.setupDistributionContainer(project);
        DistributionDownloadPlugin.setupDownloadServiceRepo(project);
    }

    private void setupDistributionContainer(Project project) {
        this.distributionsContainer = project.container(ElasticsearchDistribution.class, name -> {
            Configuration fileConfiguration = (Configuration)project.getConfigurations().create(DISTRO_CONFIG_PREFIX + name);
            fileConfiguration.setCanBeConsumed(false);
            Configuration extractedConfiguration = (Configuration)project.getConfigurations().create(DISTRO_EXTRACTED_CONFIG_PREFIX + name);
            extractedConfiguration.setCanBeConsumed(false);
            extractedConfiguration.getAttributes().attribute(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, (Object)"directory");
            ElasticsearchDistribution distribution = new ElasticsearchDistribution(name, this.objectFactory, this.dockerAvailability, this.objectFactory.fileCollection().from(new Object[]{fileConfiguration}), this.objectFactory.fileCollection().from(new Object[]{extractedConfiguration}));
            if (!this.writingDependencies) {
                this.registerDistributionDependencies(project, distribution);
            }
            return distribution;
        });
        project.getExtensions().add(CONTAINER_NAME, this.distributionsContainer);
    }

    private void registerDistributionDependencies(Project project, ElasticsearchDistribution distribution) {
        Configuration distroConfig = project.getConfigurations().getByName(DISTRO_CONFIG_PREFIX + distribution.getName());
        distroConfig.getDependencies().addLater(project.provider(() -> distribution.maybeFreeze()).map(frozenDistro -> project.getDependencies().create(this.resolveDependencyNotation(project, (ElasticsearchDistribution)frozenDistro).getDefaultNotation())));
        Configuration extractedDistroConfig = project.getConfigurations().getByName(DISTRO_EXTRACTED_CONFIG_PREFIX + distribution.getName());
        extractedDistroConfig.getDependencies().addAllLater(project.provider(() -> distribution.maybeFreeze()).map(frozenDistro -> distribution.getType().shouldExtract() ? List.of(project.getDependencies().create(this.resolveDependencyNotation(project, (ElasticsearchDistribution)frozenDistro).getExtractedNotation())) : Collections.emptyList()));
    }

    private DistributionDependency resolveDependencyNotation(Project project, ElasticsearchDistribution distro) {
        return this.distributionsResolutionStrategies.stream().sorted(Comparator.comparing(DistributionResolution::getPriority).reversed()).map(r -> r.getResolver().resolve(project, distro)).filter(Objects::nonNull).findFirst().orElseGet(() -> DistributionDependency.of(DistributionDownloadPlugin.dependencyNotation(distro)));
    }

    private static String dependencyNotation(ElasticsearchDistribution distribution) {
        if (distribution.getType() == ElasticsearchDistributionTypes.INTEG_TEST_ZIP) {
            return "org.elasticsearch.distribution.integ-test-zip:elasticsearch:" + distribution.getVersion() + "@zip";
        }
        Version distroVersion = Version.fromString(distribution.getVersion());
        String extension = distribution.getType().getExtension(distribution.getPlatform());
        String classifier = distribution.getType().getClassifier(distribution.getPlatform(), distroVersion);
        String group = distribution.getVersion().endsWith("-SNAPSHOT") ? FAKE_SNAPSHOT_IVY_GROUP : FAKE_IVY_GROUP;
        return group + ":elasticsearch:" + distribution.getVersion() + classifier + "@" + extension;
    }

    private void setupResolutionsContainer(Project project) {
        this.distributionsResolutionStrategies = new ArrayList<DistributionResolution>();
        project.getExtensions().add(RESOLUTION_CONTAINER_NAME, this.distributionsResolutionStrategies);
    }

    public static NamedDomainObjectContainer<ElasticsearchDistribution> getContainer(Project project) {
        return (NamedDomainObjectContainer)project.getExtensions().getByName(CONTAINER_NAME);
    }

    public static List<DistributionResolution> getRegistrationsContainer(Project project) {
        return (List)project.getExtensions().getByName(RESOLUTION_CONTAINER_NAME);
    }

    private static void addIvyRepo(Project project, String name, String url, String group) {
        IvyArtifactRepository ivyRepo = project.getRepositories().ivy(repo -> {
            repo.setName(name);
            repo.setUrl((Object)url);
            repo.metadataSources(IvyArtifactRepository.MetadataSources::artifact);
            repo.patternLayout(layout -> layout.artifact("/downloads/elasticsearch/[module]-[revision](-[classifier]).[ext]"));
        });
        if (project != project.getRootProject()) {
            project.getRepositories().exclusiveContent(exclusiveContentRepository -> {
                exclusiveContentRepository.filter(config -> config.includeGroup(group));
                exclusiveContentRepository.forRepositories(new ArtifactRepository[]{ivyRepo});
            });
        }
    }

    private static void setupDownloadServiceRepo(Project project) {
        if (project.getRepositories().findByName(DOWNLOAD_REPO_NAME) != null) {
            return;
        }
        DistributionDownloadPlugin.addIvyRepo(project, DOWNLOAD_REPO_NAME, "https://artifacts-no-kpi.elastic.co", FAKE_IVY_GROUP);
        DistributionDownloadPlugin.addIvyRepo(project, SNAPSHOT_REPO_NAME, "https://snapshots-no-kpi.elastic.co", FAKE_SNAPSHOT_IVY_GROUP);
    }
}

