/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authc.saml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.core.security.authc.RealmConfig;
import org.elasticsearch.xpack.core.security.authc.RealmSettings;
import org.elasticsearch.xpack.core.security.authc.support.DelegatedAuthorizationSettings;
import org.elasticsearch.xpack.core.security.authc.support.SecuritySettingsUtil;
import org.elasticsearch.xpack.core.ssl.SSLConfigurationSettings;
import org.elasticsearch.xpack.core.ssl.X509KeyPairSettings;

public class SamlRealmSettings {
    private static final String IDP_METADATA_SETTING_PREFIX = "idp.metadata.";
    public static final Function<String, Setting.AffixSetting<String>> IDP_ENTITY_ID = type -> RealmSettings.simpleString(type, "idp.entity_id", Setting.Property.NodeScope);
    public static final Function<String, Setting.AffixSetting<String>> IDP_METADATA_PATH = type -> RealmSettings.simpleString(type, "idp.metadata.path", Setting.Property.NodeScope);
    public static final Function<String, Setting.AffixSetting<TimeValue>> IDP_METADATA_HTTP_REFRESH = type -> Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix(type), (String)"idp.metadata.http.refresh", key -> Setting.timeSetting((String)key, (TimeValue)TimeValue.timeValueHours((long)1L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    public static final Function<String, Setting.AffixSetting<TimeValue>> IDP_METADATA_HTTP_MIN_REFRESH = type -> Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix(type), (String)"idp.metadata.http.minimum_refresh", key -> Setting.timeSetting((String)key, (TimeValue)TimeValue.timeValueMinutes((long)5L), (TimeValue)TimeValue.timeValueMillis((long)500L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    public static final Function<String, Setting.AffixSetting<Boolean>> IDP_METADATA_HTTP_FAIL_ON_ERROR = type -> Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix(type), (String)"idp.metadata.http.fail_on_error", key -> Setting.boolSetting((String)key, (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    public static final Function<String, Setting.AffixSetting<TimeValue>> IDP_METADATA_HTTP_CONNECT_TIMEOUT = type -> Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix(type), (String)"idp.metadata.http.connect_timeout", key -> Setting.timeSetting((String)key, (TimeValue)TimeValue.timeValueSeconds((long)5L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    public static final Function<String, Setting.AffixSetting<TimeValue>> IDP_METADATA_HTTP_READ_TIMEOUT = type -> Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix(type), (String)"idp.metadata.http.read_timeout", key -> Setting.timeSetting((String)key, (TimeValue)TimeValue.timeValueSeconds((long)10L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    public static final Function<String, Setting.AffixSetting<Boolean>> IDP_SINGLE_LOGOUT = type -> Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix(type), (String)"idp.use_single_logout", key -> Setting.boolSetting((String)key, (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    public static final Function<String, Setting.AffixSetting<String>> NAMEID_FORMAT = type -> RealmSettings.simpleString(type, "nameid_format", Setting.Property.NodeScope);
    public static final Function<String, Setting.AffixSetting<Boolean>> NAMEID_ALLOW_CREATE = type -> Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix(type), (String)"nameid.allow_create", key -> Setting.boolSetting((String)key, (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    public static final Function<String, Setting.AffixSetting<String>> NAMEID_SP_QUALIFIER = type -> RealmSettings.simpleString(type, "nameid.sp_qualifier", Setting.Property.NodeScope);
    public static final Function<String, Setting.AffixSetting<Boolean>> FORCE_AUTHN = type -> Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix(type), (String)"force_authn", key -> Setting.boolSetting((String)key, (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    public static final Function<String, Setting.AffixSetting<Boolean>> POPULATE_USER_METADATA = type -> Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix(type), (String)"populate_user_metadata", key -> Setting.boolSetting((String)key, (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    public static final Function<String, AttributeSetting> PRINCIPAL_ATTRIBUTE = type -> new AttributeSetting((String)type, "principal");
    public static final Function<String, AttributeSettingWithDelimiter> GROUPS_ATTRIBUTE = type -> new AttributeSettingWithDelimiter((String)type, "groups");
    public static final Function<String, AttributeSetting> DN_ATTRIBUTE = type -> new AttributeSetting((String)type, "dn");
    public static final Function<String, AttributeSetting> NAME_ATTRIBUTE = type -> new AttributeSetting((String)type, "name");
    public static final Function<String, AttributeSetting> MAIL_ATTRIBUTE = type -> new AttributeSetting((String)type, "mail");
    public static final String ENCRYPTION_SETTING_KEY = "encryption.";
    public static final Function<String, Setting.AffixSetting<String>> ENCRYPTION_KEY_ALIAS = type -> RealmSettings.simpleString(type, "encryption.keystore.alias", Setting.Property.NodeScope);
    public static final String SIGNING_SETTING_KEY = "signing.";
    public static final Function<String, Setting.AffixSetting<String>> SIGNING_KEY_ALIAS = type -> RealmSettings.simpleString(type, "signing.keystore.alias", Setting.Property.NodeScope);
    public static final Function<String, Setting.AffixSetting<List<String>>> SIGNING_MESSAGE_TYPES = type -> Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix(type), (String)"signing.saml_messages", key -> Setting.stringListSetting((String)key, List.of("*"), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    public static final Function<String, Setting.AffixSetting<List<String>>> REQUESTED_AUTHN_CONTEXT_CLASS_REF = type -> Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix(type), (String)"req_authn_context_class_ref", key -> Setting.stringListSetting((String)key, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    public static final Function<String, Setting.AffixSetting<TimeValue>> CLOCK_SKEW = type -> Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix(type), (String)"allowed_clock_skew", key -> Setting.positiveTimeSetting((String)key, (TimeValue)TimeValue.timeValueMinutes((long)3L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    public static final Function<String, Setting.AffixSetting<List<String>>> EXCLUDE_ROLES = type -> Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix(type), (String)"exclude_roles", (namespace, key) -> Setting.stringListSetting((String)key, (Setting.Validator)new Setting.Validator<List<String>>(){

        public void validate(List<String> excludedRoles) {
            excludedRoles.forEach(excludedRole -> SecuritySettingsUtil.verifyNonNullNotEmpty(key, excludedRole));
        }

        public void validate(List<String> excludedRoles, Map<Setting<?>, Object> settings) {
            Setting authorizationRealmsSetting;
            List authorizationRealms;
            if (!excludedRoles.isEmpty() && (authorizationRealms = (List)settings.get(authorizationRealmsSetting = DelegatedAuthorizationSettings.AUTHZ_REALMS.apply(type).getConcreteSettingForNamespace(namespace))) != null && !authorizationRealms.isEmpty()) {
                throw new SettingsException("Setting [" + key + "] is not permitted when setting [" + authorizationRealmsSetting.getKey() + "] is configured.");
            }
        }

        public Iterator<Setting<?>> settings() {
            List<Setting> settings = List.of(DelegatedAuthorizationSettings.AUTHZ_REALMS.apply(type).getConcreteSettingForNamespace(namespace));
            return settings.iterator();
        }
    }, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    public static final String SSL_PREFIX = "ssl.";

    private SamlRealmSettings() {
    }

    public static Set<Setting.AffixSetting<?>> getSettings(String type) {
        HashSet set = Sets.newHashSet((Object[])new Setting.AffixSetting[]{IDP_ENTITY_ID.apply(type), IDP_METADATA_PATH.apply(type), IDP_METADATA_HTTP_REFRESH.apply(type), IDP_METADATA_HTTP_MIN_REFRESH.apply(type), IDP_METADATA_HTTP_FAIL_ON_ERROR.apply(type), IDP_METADATA_HTTP_CONNECT_TIMEOUT.apply(type), IDP_METADATA_HTTP_READ_TIMEOUT.apply(type), IDP_SINGLE_LOGOUT.apply(type), NAMEID_FORMAT.apply(type), NAMEID_ALLOW_CREATE.apply(type), NAMEID_SP_QUALIFIER.apply(type), FORCE_AUTHN.apply(type), POPULATE_USER_METADATA.apply(type), CLOCK_SKEW.apply(type), ENCRYPTION_KEY_ALIAS.apply(type), SIGNING_KEY_ALIAS.apply(type), SIGNING_MESSAGE_TYPES.apply(type), REQUESTED_AUTHN_CONTEXT_CLASS_REF.apply(type)});
        set.addAll(X509KeyPairSettings.affix(RealmSettings.realmSettingPrefix(type), ENCRYPTION_SETTING_KEY, false));
        set.addAll(X509KeyPairSettings.affix(RealmSettings.realmSettingPrefix(type), SIGNING_SETTING_KEY, false));
        set.addAll(SSLConfigurationSettings.getRealmSettings(type));
        set.addAll(PRINCIPAL_ATTRIBUTE.apply(type).settings());
        set.addAll(GROUPS_ATTRIBUTE.apply(type).settings());
        set.addAll(DN_ATTRIBUTE.apply(type).settings());
        set.addAll(NAME_ATTRIBUTE.apply(type).settings());
        set.addAll(MAIL_ATTRIBUTE.apply(type).settings());
        set.addAll(DelegatedAuthorizationSettings.getSettings(type));
        set.addAll(RealmSettings.getStandardSettings(type));
        return set;
    }

    public static final class AttributeSetting {
        public static final String ATTRIBUTES_PREFIX = "attributes.";
        public static final String ATTRIBUTE_PATTERNS_PREFIX = "attribute_patterns.";
        private final Setting.AffixSetting<String> attribute;
        private final Setting.AffixSetting<String> pattern;

        public AttributeSetting(String type, String name) {
            this.attribute = RealmSettings.simpleString(type, ATTRIBUTES_PREFIX + name, Setting.Property.NodeScope);
            this.pattern = RealmSettings.simpleString(type, ATTRIBUTE_PATTERNS_PREFIX + name, Setting.Property.NodeScope);
        }

        public Collection<Setting.AffixSetting<?>> settings() {
            return Arrays.asList(this.getAttribute(), this.getPattern());
        }

        public String name(RealmConfig config) {
            return this.getAttribute().getConcreteSettingForNamespace(config.name()).getKey();
        }

        public Setting.AffixSetting<String> getAttribute() {
            return this.attribute;
        }

        public Setting.AffixSetting<String> getPattern() {
            return this.pattern;
        }
    }

    public static final class AttributeSettingWithDelimiter {
        public static final String ATTRIBUTE_DELIMITERS_PREFIX = "attribute_delimiters.";
        private final Setting.AffixSetting<String> delimiter;
        private final AttributeSetting attributeSetting;

        public AttributeSetting getAttributeSetting() {
            return this.attributeSetting;
        }

        public AttributeSettingWithDelimiter(String type, String name) {
            this.attributeSetting = new AttributeSetting(type, name);
            this.delimiter = RealmSettings.simpleString(type, ATTRIBUTE_DELIMITERS_PREFIX + name, Setting.Property.NodeScope);
        }

        public Setting.AffixSetting<String> getDelimiter() {
            return this.delimiter;
        }

        public Collection<Setting.AffixSetting<?>> settings() {
            ArrayList settings = new ArrayList(this.attributeSetting.settings());
            settings.add(this.getDelimiter());
            return settings;
        }
    }

    public record UserAttributeNameConfiguration(String principal, String dn, String name, String mail) {
        public static UserAttributeNameConfiguration fromConfig(RealmConfig config) {
            return new UserAttributeNameConfiguration(PRINCIPAL_ATTRIBUTE.apply(config.type()).name(config), DN_ATTRIBUTE.apply(config.type()).name(config), NAME_ATTRIBUTE.apply(config.type()).name(config), MAIL_ATTRIBUTE.apply(config.type()).name(config));
        }
    }
}

