/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.BiFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.ProjectState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.LifecycleExecutionState;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.xpack.core.ilm.ClusterStateActionStep;
import org.elasticsearch.xpack.core.ilm.Step;

public class CopySettingsStep
extends ClusterStateActionStep {
    public static final String NAME = "copy-settings";
    private static final Logger logger = LogManager.getLogger(CopySettingsStep.class);
    private final String[] settingsKeys;
    private final BiFunction<String, LifecycleExecutionState, String> targetIndexNameSupplier;

    public CopySettingsStep(Step.StepKey key, Step.StepKey nextStepKey, BiFunction<String, LifecycleExecutionState, String> targetIndexNameSupplier, String ... settingsKeys) {
        super(key, nextStepKey);
        Objects.requireNonNull(settingsKeys);
        this.settingsKeys = settingsKeys;
        this.targetIndexNameSupplier = targetIndexNameSupplier;
    }

    @Override
    public boolean isRetryable() {
        return true;
    }

    public String[] getSettingsKeys() {
        return this.settingsKeys;
    }

    BiFunction<String, LifecycleExecutionState, String> getTargetIndexNameSupplier() {
        return this.targetIndexNameSupplier;
    }

    @Override
    public ProjectState performAction(Index index, ProjectState projectState) {
        String sourceIndexName = index.getName();
        IndexMetadata sourceIndexMetadata = projectState.metadata().index(sourceIndexName);
        if (sourceIndexMetadata == null) {
            logger.debug("[{}] lifecycle action for index [{}] executed but index no longer exists", (Object)this.getKey().action(), (Object)sourceIndexName);
            return projectState;
        }
        if (this.settingsKeys == null || this.settingsKeys.length == 0) {
            return projectState;
        }
        String targetIndexName = this.targetIndexNameSupplier.apply(sourceIndexName, sourceIndexMetadata.getLifecycleExecutionState());
        IndexMetadata targetIndexMetadata = projectState.metadata().index(targetIndexName);
        if (targetIndexMetadata == null) {
            String errorMessage = Strings.format((String)"index [%s] is being referenced by ILM action [%s] on step [%s] but it doesn't exist", (Object[])new Object[]{targetIndexName, this.getKey().action(), this.getKey().name()});
            logger.debug(errorMessage);
            throw new IllegalStateException(errorMessage);
        }
        Settings.Builder settings = Settings.builder().put(targetIndexMetadata.getSettings());
        for (String key : this.settingsKeys) {
            String value = sourceIndexMetadata.getSettings().get(key);
            settings.put(key, value);
        }
        IndexMetadata.Builder updatedIndex = IndexMetadata.builder((IndexMetadata)targetIndexMetadata).settingsVersion(targetIndexMetadata.getSettingsVersion() + 1L).settings(settings);
        return projectState.updateProject(ProjectMetadata.builder((ProjectMetadata)projectState.metadata()).put(updatedIndex).build());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CopySettingsStep that = (CopySettingsStep)o;
        return super.equals(o) && Objects.equals(this.targetIndexNameSupplier, that.targetIndexNameSupplier) && Arrays.equals(this.settingsKeys, that.settingsKeys);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.targetIndexNameSupplier, Arrays.hashCode(this.settingsKeys));
    }
}

