/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.logsdb;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.index.IndexSettingProvider;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.license.LicenseService;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.MapperPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.action.XPackInfoFeatureAction;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureAction;
import org.elasticsearch.xpack.logsdb.LogsDBInfoTransportAction;
import org.elasticsearch.xpack.logsdb.LogsDBUsageTransportAction;
import org.elasticsearch.xpack.logsdb.LogsdbIndexModeSettingsProvider;
import org.elasticsearch.xpack.logsdb.LogsdbLicenseService;
import org.elasticsearch.xpack.logsdb.patternedtext.PatternedTextFieldMapper;

public class LogsDBPlugin
extends Plugin
implements ActionPlugin,
MapperPlugin {
    private final Settings settings;
    private final LogsdbLicenseService licenseService;
    private static final Setting<Boolean> LOGSDB_PRIOR_LOGS_USAGE = Setting.boolSetting((String)"logsdb.prior_logs_usage", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    public static final Setting<Boolean> CLUSTER_LOGSDB_ENABLED = Setting.boolSetting((String)"cluster.logsdb.enabled", settings -> Boolean.toString((Boolean)LOGSDB_PRIOR_LOGS_USAGE.get(settings) == false), (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    private final LogsdbIndexModeSettingsProvider logsdbIndexModeSettingsProvider;

    public LogsDBPlugin(Settings settings) {
        this.settings = settings;
        this.licenseService = new LogsdbLicenseService(settings);
        this.logsdbIndexModeSettingsProvider = new LogsdbIndexModeSettingsProvider(this.licenseService, settings);
    }

    public Collection<?> createComponents(Plugin.PluginServices services) {
        this.licenseService.setLicenseService(this.getLicenseService());
        this.licenseService.setLicenseState(this.getLicenseState());
        ClusterSettings clusterSettings = services.clusterService().getClusterSettings();
        this.logsdbIndexModeSettingsProvider.updateClusterIndexModeLogsdbEnabled((Boolean)clusterSettings.get(CLUSTER_LOGSDB_ENABLED));
        clusterSettings.addSettingsUpdateConsumer(LogsdbLicenseService.FALLBACK_SETTING, this.licenseService::setSyntheticSourceFallback);
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_LOGSDB_ENABLED, this.logsdbIndexModeSettingsProvider::updateClusterIndexModeLogsdbEnabled);
        return super.createComponents(services);
    }

    public Collection<IndexSettingProvider> getAdditionalIndexSettingProviders(IndexSettingProvider.Parameters parameters) {
        this.logsdbIndexModeSettingsProvider.init((CheckedFunction<IndexMetadata, MapperService, IOException>)parameters.mapperServiceFactory(), () -> IndexVersion.min((IndexVersion)IndexVersion.current(), (IndexVersion)parameters.clusterService().state().nodes().getMaxDataNodeCompatibleIndexVersion()), () -> parameters.clusterService().state().nodes().getMinNodeVersion(), !DiscoveryNode.isStateless((Settings)this.settings), !DiscoveryNode.isStateless((Settings)this.settings));
        return List.of(this.logsdbIndexModeSettingsProvider);
    }

    public List<Setting<?>> getSettings() {
        return List.of(LogsdbLicenseService.FALLBACK_SETTING, CLUSTER_LOGSDB_ENABLED, LOGSDB_PRIOR_LOGS_USAGE);
    }

    public List<ActionPlugin.ActionHandler> getActions() {
        ArrayList<ActionPlugin.ActionHandler> actions = new ArrayList<ActionPlugin.ActionHandler>();
        actions.add(new ActionPlugin.ActionHandler(XPackUsageFeatureAction.LOGSDB, LogsDBUsageTransportAction.class));
        actions.add(new ActionPlugin.ActionHandler(XPackInfoFeatureAction.LOGSDB, LogsDBInfoTransportAction.class));
        return actions;
    }

    public Map<String, Mapper.TypeParser> getMappers() {
        if (PatternedTextFieldMapper.PATTERNED_TEXT_MAPPER.isEnabled()) {
            return Collections.singletonMap("patterned_text", PatternedTextFieldMapper.PARSER);
        }
        return Map.of();
    }

    protected XPackLicenseState getLicenseState() {
        return XPackPlugin.getSharedLicenseState();
    }

    protected LicenseService getLicenseService() {
        return XPackPlugin.getSharedLicenseService();
    }
}

