/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.aggs.frequentitemsets.mr;

import java.util.function.Consumer;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.breaker.CircuitBreakingException;
import org.elasticsearch.indices.breaker.AllCircuitBreakerStats;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.indices.breaker.CircuitBreakerStats;

final class DelegatingCircuitBreakerService
extends CircuitBreakerService {
    private final DelegatingCircuitBreaker breaker;

    DelegatingCircuitBreakerService(CircuitBreaker wrappedBreaker, Consumer<Long> addToBreakerOverwrite) {
        this.breaker = new DelegatingCircuitBreaker(wrappedBreaker, addToBreakerOverwrite);
    }

    void disconnect() {
        this.breaker.disconnect();
    }

    public CircuitBreaker getBreaker(String name) {
        return this.breaker;
    }

    public AllCircuitBreakerStats stats() {
        return new AllCircuitBreakerStats(new CircuitBreakerStats[]{this.stats(this.breaker.getName())});
    }

    public CircuitBreakerStats stats(String name) {
        return new CircuitBreakerStats(name, this.breaker.getLimit(), 0L, this.breaker.getOverhead(), this.breaker.getTrippedCount());
    }

    private static class DelegatingCircuitBreaker
    implements CircuitBreaker {
        private CircuitBreaker wrappedBreaker;
        private final Consumer<Long> addToBreakerOverwrite;
        private final String name;

        DelegatingCircuitBreaker(CircuitBreaker wrappedBreaker, Consumer<Long> addToBreakerOverwrite) {
            this.wrappedBreaker = wrappedBreaker;
            this.addToBreakerOverwrite = addToBreakerOverwrite;
            this.name = wrappedBreaker.getName();
        }

        synchronized void disconnect() {
            this.wrappedBreaker = null;
        }

        public void circuitBreak(String fieldName, long bytesNeeded) {
            CircuitBreaker theBreaker = this.wrappedBreaker;
            if (theBreaker != null) {
                theBreaker.circuitBreak(fieldName, bytesNeeded);
            }
        }

        public void addEstimateBytesAndMaybeBreak(long bytes, String label) throws CircuitBreakingException {
            if (this.wrappedBreaker != null) {
                this.doAddToBreakerOverwrite(bytes);
            }
        }

        public void addWithoutBreaking(long bytes) {
            if (this.wrappedBreaker != null) {
                this.doAddToBreakerOverwrite(bytes);
            }
        }

        public long getUsed() {
            CircuitBreaker theBreaker = this.wrappedBreaker;
            if (theBreaker != null) {
                return theBreaker.getUsed();
            }
            return 0L;
        }

        public long getLimit() {
            CircuitBreaker theBreaker = this.wrappedBreaker;
            if (theBreaker != null) {
                return theBreaker.getLimit();
            }
            return 0L;
        }

        public double getOverhead() {
            CircuitBreaker theBreaker = this.wrappedBreaker;
            if (theBreaker != null) {
                return theBreaker.getOverhead();
            }
            return 0.0;
        }

        public long getTrippedCount() {
            CircuitBreaker theBreaker = this.wrappedBreaker;
            if (theBreaker != null) {
                return theBreaker.getTrippedCount();
            }
            return 0L;
        }

        public String getName() {
            return this.name;
        }

        public CircuitBreaker.Durability getDurability() {
            CircuitBreaker theBreaker = this.wrappedBreaker;
            if (theBreaker != null) {
                return theBreaker.getDurability();
            }
            return CircuitBreaker.Durability.TRANSIENT;
        }

        public void setLimitAndOverhead(long limit, double overhead) {
            CircuitBreaker theBreaker = this.wrappedBreaker;
            if (theBreaker != null) {
                theBreaker.setLimitAndOverhead(limit, overhead);
            }
        }

        private synchronized void doAddToBreakerOverwrite(long bytes) {
            if (this.wrappedBreaker != null) {
                this.addToBreakerOverwrite.accept(bytes);
            }
        }
    }
}

