/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.aggs.categorization;

import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.common.util.BytesRefHash;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.xpack.ml.aggs.categorization.CategorizeTextAggregationBuilder;

public class CategorizationBytesRefHash
implements Releasable {
    private final BytesRefHash bytesRefHash;

    public CategorizationBytesRefHash(BytesRefHash bytesRefHash) {
        this.bytesRefHash = bytesRefHash;
    }

    int[] getIds(BytesRef[] tokens) {
        int[] ids = new int[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            ids[i] = this.put(tokens[i]);
        }
        return ids;
    }

    BytesRef[] getDeeps(int[] ids) {
        BytesRef[] tokens = new BytesRef[ids.length];
        for (int i = 0; i < tokens.length; ++i) {
            tokens[i] = this.getDeep(ids[i]);
        }
        return tokens;
    }

    BytesRef getDeep(long id) {
        BytesRef shallow = this.bytesRefHash.get(id, new BytesRef());
        return BytesRef.deepCopyOf((BytesRef)shallow);
    }

    int put(BytesRef bytesRef) {
        long hash = this.bytesRefHash.add(bytesRef);
        if (hash < 0L) {
            return (int)(-1L - hash);
        }
        if (hash > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(LoggerMessageFormat.format((String)"more than [{}] unique terms encountered. Consider restricting the documents queried or adding [{}] in the {} configuration", (Object[])new Object[]{Integer.MAX_VALUE, CategorizeTextAggregationBuilder.CATEGORIZATION_FILTERS.getPreferredName(), "categorize_text"}));
        }
        return (int)hash;
    }

    public void close() {
        this.bytesRefHash.close();
    }
}

