/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.operation;

import java.util.function.IntSupplier;
import org.ojalgo.array.operation.AXPY;
import org.ojalgo.concurrent.DivideAndConquer;
import org.ojalgo.concurrent.Parallelism;
import org.ojalgo.concurrent.ProcessingService;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.matrix.operation.MatrixOperation;
import org.ojalgo.matrix.transformation.Householder;
import org.ojalgo.scalar.Scalar;

public final class HouseholderRight
implements MatrixOperation {
    public static IntSupplier PARALLELISM = Parallelism.THREADS;
    public static int THRESHOLD = 256;
    private static final DivideAndConquer.Divider DIVIDER = ProcessingService.INSTANCE.divider();

    public static void call(double[] data, int structure, int first, Householder.Primitive64 householder, double[] work) {
        int nbRows = structure;
        int nbCols = data.length / structure;
        double[] hVector = householder.vector;
        int hFirst = householder.first;
        double hBeta = householder.beta;
        HouseholderRight.step1(data, structure, first, work, nbRows, nbCols, hVector, hFirst, hBeta);
        if (nbCols > THRESHOLD) {
            HouseholderRight.divide(hFirst, nbCols, (f, l) -> HouseholderRight.step2(data, structure, first, work, nbRows, l, hVector, f));
        } else {
            HouseholderRight.step2(data, structure, first, work, nbRows, nbCols, hVector, hFirst);
        }
    }

    public static void call(float[] data, int structure, int first, Householder.Primitive32 householder, float[] work) {
        int nbRows = structure;
        int nbCols = data.length / structure;
        float[] hVector = householder.vector;
        int hFirst = householder.first;
        float hBeta = householder.beta;
        HouseholderRight.step1(data, structure, first, work, nbRows, nbCols, hVector, hFirst, hBeta);
        if (nbCols > THRESHOLD) {
            HouseholderRight.divide(hFirst, nbCols, (f, l) -> HouseholderRight.step2(data, structure, first, work, nbRows, l, hVector, f));
        } else {
            HouseholderRight.step2(data, structure, first, work, nbRows, nbCols, hVector, hFirst);
        }
    }

    public static <N extends Scalar<N>> void call(N[] data, int structure, int first, Householder.Generic<N> householder, Scalar.Factory<N> scalar) {
        int nbRows = structure;
        int nbCols = data.length / structure;
        HouseholderRight.divide(first, nbRows, (f, l) -> HouseholderRight.invoke((Scalar[])data, (int)structure, (int)f, (int)l, (int)nbCols, (Householder.Generic)householder, (Scalar.Factory)scalar));
    }

    private static void invoke(double[] data, int structure, int first, int limit, int numberOfColumns, Householder.Primitive64 householder, double[] work) {
        double[] hVector = householder.vector;
        int hFirst = householder.first;
        double hBeta = householder.beta;
        HouseholderRight.step1(data, structure, first, work, limit, numberOfColumns, hVector, hFirst, hBeta);
        HouseholderRight.step2(data, structure, first, work, limit, numberOfColumns, hVector, hFirst);
    }

    private static void invoke(float[] data, int structure, int first, int limit, int numberOfColumns, Householder.Primitive32 householder, float[] work) {
        float[] hVector = householder.vector;
        int hFirst = householder.first;
        float hBeta = householder.beta;
        HouseholderRight.step1(data, structure, first, work, limit, numberOfColumns, hVector, hFirst, hBeta);
        HouseholderRight.step2(data, structure, first, work, limit, numberOfColumns, hVector, hFirst);
    }

    private static <N extends Scalar<N>> void invoke(N[] data, int structure, int first, int limit, int numberOfColumns, Householder.Generic<N> householder, Scalar.Factory<N> scalar) {
        N[] hVector = householder.vector;
        int hFirst = householder.first;
        Object hBeta = householder.beta;
        for (int i = first; i < limit; ++i) {
            int j;
            Scalar tmpScale = scalar.zero();
            int tmpIndex = i + hFirst * structure;
            for (j = hFirst; j < numberOfColumns; ++j) {
                tmpScale = tmpScale.add(((Scalar)hVector[j].conjugate()).multiply((Scalar)data[tmpIndex].conjugate()));
                tmpIndex += structure;
            }
            tmpScale = (Scalar)tmpScale.multiply(hBeta);
            tmpIndex = i + hFirst * structure;
            for (j = hFirst; j < numberOfColumns; ++j) {
                data[tmpIndex] = (Scalar)((Scalar)((Scalar)data[tmpIndex].conjugate()).subtract((Scalar)tmpScale.multiply(hVector[j])).conjugate()).get();
                tmpIndex += structure;
            }
        }
    }

    private static void invoke2new(double[] data, int structure, int first, int limit, int numberOfColumns, Householder.Primitive64 householder) {
        double[] hVector = householder.vector;
        int hFirst = householder.first;
        double hBeta = householder.beta;
        for (int i = first; i < limit; ++i) {
            int j;
            double tmpScale = PrimitiveMath.ZERO;
            for (j = hFirst; j < numberOfColumns; ++j) {
                tmpScale += hVector[j] * data[i + j * structure];
            }
            tmpScale *= hBeta;
            for (j = hFirst; j < numberOfColumns; ++j) {
                int n = i + j * structure;
                data[n] = data[n] - hVector[j] * tmpScale;
            }
        }
    }

    private static void invoke2old(double[] data, int structure, int first, int limit, int numberOfColumns, Householder.Primitive64 householder) {
        double[] hVector = householder.vector;
        int hFirst = householder.first;
        double hBeta = householder.beta;
        for (int i = first; i < limit; ++i) {
            int j;
            double tmpScale = PrimitiveMath.ZERO;
            int tmpIndex = i + hFirst * structure;
            for (j = hFirst; j < numberOfColumns; ++j) {
                tmpScale += hVector[j] * data[tmpIndex];
                tmpIndex += structure;
            }
            tmpScale *= hBeta;
            tmpIndex = i + hFirst * structure;
            for (j = hFirst; j < numberOfColumns; ++j) {
                int n = tmpIndex;
                data[n] = data[n] - tmpScale * hVector[j];
                tmpIndex += structure;
            }
        }
    }

    private static void step1(double[] data, int structure, int first, double[] work, int nbRows, int nbCols, double[] hVector, int hFirst, double hBeta) {
        for (int j = hFirst; j < nbCols; ++j) {
            AXPY.invoke(work, 0, hBeta * hVector[j], data, j * structure, first, nbRows);
        }
    }

    private static void step1(float[] data, int structure, int first, float[] work, int nbRows, int nbCols, float[] hVector, int hFirst, float hBeta) {
        for (int j = hFirst; j < nbCols; ++j) {
            AXPY.invoke(work, 0, hBeta * hVector[j], data, j * structure, first, nbRows);
        }
    }

    private static void step2(double[] data, int structure, int first, double[] work, int nbRows, int nbCols, double[] hVector, int hFirst) {
        for (int j = hFirst; j < nbCols; ++j) {
            AXPY.invoke(data, j * structure, -hVector[j], work, 0, first, nbRows);
        }
    }

    private static void step2(float[] data, int structure, int first, float[] work, int nbRows, int nbCols, float[] hVector, int hFirst) {
        for (int j = hFirst; j < nbCols; ++j) {
            AXPY.invoke(data, j * structure, -hVector[j], work, 0, first, nbRows);
        }
    }

    static void divide(int first, int limit, DivideAndConquer.Conquerer conquerer) {
        DIVIDER.parallelism(PARALLELISM).threshold(THRESHOLD).divide(first, limit, conquerer);
    }
}

