/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.sagemaker.schema.openai;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.sagemaker.schema.SageMakerStoredTaskSchema;

record SageMakerOpenAiTaskSettings(@Nullable String user) implements SageMakerStoredTaskSchema
{
    static final String NAME = "sagemaker_openai_task_settings";
    private static final String USER_FIELD = "user";
    public static final TransportVersion ML_INFERENCE_SAGEMAKER_CHAT_COMPLETION = TransportVersion.fromName((String)"ml_inference_sagemaker_chat_completion");

    SageMakerOpenAiTaskSettings(StreamInput in) throws IOException {
        this(in.readOptionalString());
    }

    public String getWriteableName() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        assert (false) : "should never be called when supportsVersion is used";
        return ML_INFERENCE_SAGEMAKER_CHAT_COMPLETION;
    }

    public boolean supportsVersion(TransportVersion version) {
        return version.supports(ML_INFERENCE_SAGEMAKER_CHAT_COMPLETION);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.user);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return this.user != null ? builder.field(USER_FIELD, this.user) : builder;
    }

    public boolean isEmpty() {
        return this.user == null;
    }

    @Override
    public SageMakerOpenAiTaskSettings updatedTaskSettings(Map<String, Object> newSettings) {
        ValidationException validationException = new ValidationException();
        SageMakerOpenAiTaskSettings newTaskSettings = SageMakerOpenAiTaskSettings.fromMap(newSettings, validationException);
        validationException.throwIfValidationErrorsExist();
        return new SageMakerOpenAiTaskSettings(newTaskSettings.user() != null ? newTaskSettings.user() : this.user);
    }

    static SageMakerOpenAiTaskSettings fromMap(Map<String, Object> map, ValidationException exception) {
        String user = ServiceUtils.extractOptionalString(map, USER_FIELD, "task_settings", exception);
        return new SageMakerOpenAiTaskSettings(user);
    }
}

