/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.premain.common;

import co.elastic.apm.agent.premain.common.util.SystemStandardOutputLogger;
import javax.annotation.Nullable;

public class JvmRuntimeInfo {
    private static final JvmRuntimeInfo CURRENT_VM = new JvmRuntimeInfo(System.getProperty("java.version"), System.getProperty("java.vm.name"), System.getProperty("java.vendor"), System.getProperty("java.vm.version"), System.getProperty("os.name"));
    private final String javaVersion;
    private final String javaVmName;
    @Nullable
    private final String javaVmVersion;
    private final int majorVersion;
    private final int updateVersion;
    private final boolean isHotSpot;
    private final boolean isIbmJ9;
    private final boolean isJ9;
    private final boolean isHpUx;
    private final boolean isCoretto;
    private final boolean isZos;
    private final boolean isOs400;

    public static JvmRuntimeInfo ofCurrentVM() {
        return CURRENT_VM;
    }

    public JvmRuntimeInfo(String version, String vmName, String vendorName, @Nullable String vmVersion) {
        this(version, vmName, vendorName, vmVersion, null);
    }

    private JvmRuntimeInfo(String version, String vmName, String vendorName, @Nullable String vmVersion, @Nullable String osName) {
        this.javaVersion = version;
        this.javaVmName = vmName;
        this.javaVmVersion = vmVersion;
        this.isHotSpot = vmName.contains("HotSpot(TM)") || vmName.contains("OpenJDK");
        this.isIbmJ9 = vmName.contains("IBM J9");
        this.isJ9 = vmName.contains("J9");
        this.isHpUx = version.endsWith("-hp-ux");
        this.isCoretto = vendorName != null && vendorName.contains("Amazon");
        this.isZos = osName != null && osName.toLowerCase().contains("z/os");
        boolean bl = this.isOs400 = osName != null && osName.toLowerCase().contains("os/400");
        if (this.isHpUx) {
            version = version.substring(0, version.length() - 6);
        }
        if (version.startsWith("1.")) {
            this.majorVersion = Character.digit(version.charAt(2), 10);
        } else {
            String majorAsString = version.split("\\.")[0];
            int indexOfDash = majorAsString.indexOf(45);
            if (indexOfDash > 0) {
                majorAsString = majorAsString.substring(0, indexOfDash);
            }
            this.majorVersion = Integer.parseInt(majorAsString);
        }
        this.updateVersion = this.getUpdateVersion(version);
    }

    private int getUpdateVersion(String version) {
        int updateVersion;
        int updateIndex = version.lastIndexOf("_");
        if (updateIndex <= 0) {
            if (this.isHpUx) {
                try {
                    updateVersion = Integer.parseInt(version.substring(version.lastIndexOf(46) + 1));
                }
                catch (NumberFormatException e) {
                    updateVersion = -1;
                }
            } else {
                updateVersion = 0;
            }
        } else {
            int versionSuffixIndex = version.indexOf(45, updateIndex + 1);
            String updateVersionString = versionSuffixIndex <= 0 ? version.substring(updateIndex + 1) : version.substring(updateIndex + 1, versionSuffixIndex);
            try {
                updateVersion = Integer.parseInt(updateVersionString);
            }
            catch (NumberFormatException e) {
                updateVersion = -1;
            }
        }
        if (updateVersion < 0) {
            SystemStandardOutputLogger.stdErrWarn("Unsupported format of the java.version system property - " + version);
        }
        return updateVersion;
    }

    public String getJavaVersion() {
        return this.javaVersion;
    }

    public String getJavaVmName() {
        return this.javaVmName;
    }

    @Nullable
    public String getJavaVmVersion() {
        return this.javaVmVersion;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getUpdateVersion() {
        return this.updateVersion;
    }

    public boolean isJ9VM() {
        return this.isJ9;
    }

    public boolean isHpUx() {
        return this.isHpUx;
    }

    public boolean isHotSpot() {
        return this.isHotSpot;
    }

    public boolean isIbmJ9() {
        return this.isIbmJ9;
    }

    public boolean isCoretto() {
        return this.isCoretto;
    }

    public boolean isZos() {
        return this.isZos;
    }

    public boolean isOs400() {
        return this.isOs400;
    }

    public String toString() {
        return String.format("%s %s %s", this.javaVersion, this.javaVmName, this.javaVmVersion);
    }
}

