/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.profiling.rest;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestCancellableNodeClient;
import org.elasticsearch.rest.action.RestRefCountedChunkedToXContentListener;
import org.elasticsearch.xpack.profiling.action.GetStackTracesAction;
import org.elasticsearch.xpack.profiling.action.GetStackTracesRequest;

@ServerlessScope(value=Scope.PUBLIC)
public class RestGetStackTracesAction
extends BaseRestHandler {
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.POST, "/_profiling/stacktraces"));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        GetStackTracesRequest getStackTracesRequest = new GetStackTracesRequest();
        request.applyContentParser(getStackTracesRequest::parseXContent);
        return channel -> {
            RestCancellableNodeClient cancelClient = new RestCancellableNodeClient(client, request.getHttpChannel());
            cancelClient.execute((ActionType)GetStackTracesAction.INSTANCE, (ActionRequest)getStackTracesRequest, (ActionListener)new RestRefCountedChunkedToXContentListener(channel));
        };
    }

    public String getName() {
        return "get_profiling_action";
    }
}

