/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.index.fielddata;

import java.io.IOException;
import java.text.ParseException;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.apache.lucene.document.ShapeField;
import org.apache.lucene.geo.Component2D;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.geo.SpatialPoint;
import org.elasticsearch.common.io.stream.GenericNamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.utils.GeometryValidator;
import org.elasticsearch.geometry.utils.WellKnownText;
import org.elasticsearch.index.mapper.ShapeIndexer;
import org.elasticsearch.lucene.spatial.BinaryShapeDocValuesField;
import org.elasticsearch.lucene.spatial.Component2DVisitor;
import org.elasticsearch.lucene.spatial.CoordinateEncoder;
import org.elasticsearch.lucene.spatial.DimensionalShapeType;
import org.elasticsearch.lucene.spatial.Extent;
import org.elasticsearch.lucene.spatial.GeometryDocValueReader;
import org.elasticsearch.lucene.spatial.TriangleTreeVisitor;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.spatial.index.fielddata.Component2DRelationVisitor;
import org.elasticsearch.xpack.spatial.index.fielddata.GeoRelation;
import org.elasticsearch.xpack.spatial.index.fielddata.LabelPositionVisitor;

public abstract class ShapeValues<T extends ShapeValue> {
    protected final CoordinateEncoder encoder;
    protected final Supplier<T> supplier;
    protected final ShapeIndexer missingShapeIndexer;

    protected ShapeValues(CoordinateEncoder encoder, Supplier<T> supplier, ShapeIndexer missingShapeIndexer) {
        this.encoder = encoder;
        this.supplier = supplier;
        this.missingShapeIndexer = missingShapeIndexer;
    }

    public abstract boolean advanceExact(int var1) throws IOException;

    public abstract ValuesSourceType valuesSourceType();

    public abstract T value() throws IOException;

    public abstract GeometryValidator geometryValidator();

    public T missing(String missing) {
        try {
            Geometry geometry = WellKnownText.fromWKT(this.geometryValidator(), true, missing);
            BinaryShapeDocValuesField field = new BinaryShapeDocValuesField("missing", this.encoder);
            field.add(this.missingShapeIndexer.indexShape(geometry), geometry);
            ShapeValue value = (ShapeValue)this.supplier.get();
            value.reset(field.binaryValue());
            return (T)value;
        }
        catch (IOException | ParseException e) {
            throw new IllegalArgumentException("Can't apply missing value [" + missing + "]", e);
        }
    }

    protected static abstract class ShapeValue
    implements ToXContentFragment,
    GenericNamedWriteable {
        private final GeometryDocValueReader reader = new GeometryDocValueReader();
        private final BoundingBox boundingBox = new BoundingBox();
        private final CoordinateEncoder encoder;
        private final BiFunction<Double, Double, SpatialPoint> pointMaker;
        private final Component2DRelationVisitor component2DRelationVisitor;

        public ShapeValue(CoordinateEncoder encoder, BiFunction<Double, Double, SpatialPoint> pointMaker) {
            this.encoder = encoder;
            this.pointMaker = pointMaker;
            this.component2DRelationVisitor = new Component2DRelationVisitor(encoder);
        }

        public void reset(BytesRef bytesRef) throws IOException {
            this.reader.reset(bytesRef);
            this.boundingBox.reset(this.reader.getExtent(), this.encoder);
        }

        protected void reset(StreamInput in) throws IOException {
            BytesReference bytes = in.readBytesReference();
            this.reset(bytes.toBytesRef());
        }

        public BoundingBox boundingBox() {
            return this.boundingBox;
        }

        public void visit(TriangleTreeVisitor visitor) throws IOException {
            this.reader.visit(visitor);
        }

        protected abstract Component2D centroidAsComponent2D() throws IOException;

        private boolean centroidWithinShape() throws IOException {
            Component2DVisitor visitor = Component2DVisitor.getVisitor(this.centroidAsComponent2D(), ShapeField.QueryRelation.INTERSECTS, this.encoder);
            this.reader.visit(visitor);
            return visitor.matches();
        }

        public SpatialPoint labelPosition() throws IOException {
            if (this.reader.getDimensionalShapeType() == DimensionalShapeType.POLYGON && this.centroidWithinShape()) {
                return this.pointMaker.apply(this.getX(), this.getY());
            }
            LabelPositionVisitor visitor = new LabelPositionVisitor(this.encoder, this.pointMaker);
            this.visit(visitor);
            return visitor.labelPosition();
        }

        public GeoRelation relate(Component2D component2D) throws IOException {
            this.component2DRelationVisitor.reset(component2D);
            this.reader.visit(this.component2DRelationVisitor);
            return this.component2DRelationVisitor.relation();
        }

        public DimensionalShapeType dimensionalShapeType() {
            return this.reader.getDimensionalShapeType();
        }

        public double weight() throws IOException {
            return this.reader.getSumCentroidWeight();
        }

        public double getY() throws IOException {
            return this.encoder.decodeY(this.reader.getCentroidY());
        }

        public double getX() throws IOException {
            return this.encoder.decodeX(this.reader.getCentroidX());
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            throw new IllegalArgumentException("cannot write xcontent for geo_shape doc value");
        }

        @Override
        public TransportVersion getMinimalSupportedVersion() {
            return TransportVersions.V_8_12_0;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeBytesReference(new BytesArray(this.reader.getBytesRef()));
        }

        public boolean equals(Object obj) {
            if (obj instanceof ShapeValue) {
                ShapeValue other = (ShapeValue)obj;
                return this.reader.getBytesRef().equals(other.reader.getBytesRef());
            }
            return false;
        }

        public int hashCode() {
            return this.reader.getBytesRef().hashCode();
        }
    }

    public static class BoundingBox {
        public double top;
        public double bottom;
        public double negLeft;
        public double negRight;
        public double posLeft;
        public double posRight;

        private void reset(Extent extent, CoordinateEncoder coordinateEncoder) {
            this.top = coordinateEncoder.decodeY(extent.top);
            this.bottom = coordinateEncoder.decodeY(extent.bottom);
            if (extent.negLeft == Integer.MAX_VALUE && extent.negRight == Integer.MIN_VALUE) {
                this.negLeft = Double.POSITIVE_INFINITY;
                this.negRight = Double.NEGATIVE_INFINITY;
            } else {
                this.negLeft = coordinateEncoder.decodeX(extent.negLeft);
                this.negRight = coordinateEncoder.decodeX(extent.negRight);
            }
            if (extent.posLeft == Integer.MAX_VALUE && extent.posRight == Integer.MIN_VALUE) {
                this.posLeft = Double.POSITIVE_INFINITY;
                this.posRight = Double.NEGATIVE_INFINITY;
            } else {
                this.posLeft = coordinateEncoder.decodeX(extent.posLeft);
                this.posRight = coordinateEncoder.decodeX(extent.posRight);
            }
        }

        public double minY() {
            return this.bottom;
        }

        public double maxY() {
            return this.top;
        }

        public double minX() {
            return Math.min(this.negLeft, this.posLeft);
        }

        public double maxX() {
            return Math.max(this.negRight, this.posRight);
        }
    }
}

