/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authc;

import java.util.Set;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.xpack.core.security.authc.RealmSettings;

public record DomainConfig(String name, Set<String> memberRealmNames, boolean literalUsername, String suffix) implements Comparable<DomainConfig>
{
    public DomainConfig {
        Setting<String> suffixSetting = RealmSettings.DOMAIN_UID_SUFFIX_SETTING.getConcreteSettingForNamespace(name);
        Setting<Boolean> literalUsernameSetting = RealmSettings.DOMAIN_UID_LITERAL_USERNAME_SETTING.getConcreteSettingForNamespace(name);
        if (literalUsername && suffix == null) {
            throw new IllegalArgumentException("[" + suffixSetting.getKey() + "] must be configured when [" + literalUsernameSetting.getKey() + "] is set to [true]");
        }
        if (!literalUsername && suffix != null) {
            throw new IllegalArgumentException("[" + suffixSetting.getKey() + "] must not be configured when [" + literalUsernameSetting.getKey() + "] is set to [false]");
        }
    }

    @Override
    public int compareTo(DomainConfig o) {
        return this.name.compareTo(o.name);
    }
}

