/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.role;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.client.internal.ElasticsearchClient;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.security.action.role.PutRoleAction;
import org.elasticsearch.xpack.core.security.action.role.PutRoleRequest;
import org.elasticsearch.xpack.core.security.action.role.PutRoleResponse;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;

public class PutRoleRequestBuilder
extends ActionRequestBuilder<PutRoleRequest, PutRoleResponse> {
    private static final RoleDescriptor.Parser ROLE_DESCRIPTOR_PARSER = RoleDescriptor.parserBuilder().allowDescription(true).build();

    public PutRoleRequestBuilder(ElasticsearchClient client) {
        super(client, PutRoleAction.INSTANCE, new PutRoleRequest());
    }

    public PutRoleRequestBuilder source(String name, BytesReference source, XContentType xContentType) throws IOException {
        RoleDescriptor descriptor = ROLE_DESCRIPTOR_PARSER.parse(name, source, xContentType);
        assert (name.equals(descriptor.getName()));
        ((PutRoleRequest)this.request).name(name);
        ((PutRoleRequest)this.request).cluster(descriptor.getClusterPrivileges());
        ((PutRoleRequest)this.request).conditionalCluster(descriptor.getConditionalClusterPrivileges());
        ((PutRoleRequest)this.request).addIndex(descriptor.getIndicesPrivileges());
        ((PutRoleRequest)this.request).addRemoteIndex(descriptor.getRemoteIndicesPrivileges());
        ((PutRoleRequest)this.request).putRemoteCluster(descriptor.getRemoteClusterPermissions());
        ((PutRoleRequest)this.request).addApplicationPrivileges(descriptor.getApplicationPrivileges());
        ((PutRoleRequest)this.request).runAs(descriptor.getRunAs());
        ((PutRoleRequest)this.request).metadata(descriptor.getMetadata());
        ((PutRoleRequest)this.request).description(descriptor.getDescription());
        return this;
    }

    public PutRoleRequestBuilder name(String name) {
        ((PutRoleRequest)this.request).name(name);
        return this;
    }

    public PutRoleRequestBuilder description(String description) {
        ((PutRoleRequest)this.request).description(description);
        return this;
    }

    public PutRoleRequestBuilder cluster(String ... cluster) {
        ((PutRoleRequest)this.request).cluster(cluster);
        return this;
    }

    public PutRoleRequestBuilder runAs(String ... runAsUsers) {
        ((PutRoleRequest)this.request).runAs(runAsUsers);
        return this;
    }

    public PutRoleRequestBuilder addIndices(String[] indices, String[] privileges, String[] grantedFields, String[] deniedFields, @Nullable BytesReference query, boolean allowRestrictedIndices) {
        ((PutRoleRequest)this.request).addIndex(indices, privileges, grantedFields, deniedFields, query, allowRestrictedIndices);
        return this;
    }

    public PutRoleRequestBuilder metadata(Map<String, Object> metadata) {
        ((PutRoleRequest)this.request).metadata(metadata);
        return this;
    }

    public PutRoleRequestBuilder setRefreshPolicy(@Nullable String refreshPolicy) {
        ((PutRoleRequest)this.request).setRefreshPolicy(refreshPolicy);
        return this;
    }
}

