/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.dataframe.analyses;

import java.util.Objects;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class FieldCardinalityConstraint {
    private final String field;
    private final long lowerBound;
    private final long upperBound;

    public static FieldCardinalityConstraint between(String field, long lowerBound, long upperBound) {
        return new FieldCardinalityConstraint(field, lowerBound, upperBound);
    }

    private FieldCardinalityConstraint(String field, long lowerBound, long upperBound) {
        this.field = Objects.requireNonNull(field);
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    public String getField() {
        return this.field;
    }

    public long getLowerBound() {
        return this.lowerBound;
    }

    public long getUpperBound() {
        return this.upperBound;
    }

    public void check(long fieldCardinality) {
        if (fieldCardinality < this.lowerBound) {
            throw ExceptionsHelper.badRequestException("Field [{}] must have at least [{}] distinct values but there were [{}]", this.field, this.lowerBound, fieldCardinality);
        }
        if (fieldCardinality > this.upperBound) {
            throw ExceptionsHelper.badRequestException("Field [{}] must have at most [{}] distinct values but there were at least [{}]", this.field, this.upperBound, fieldCardinality);
        }
    }
}

