/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.queries.spans.SpanContainingQuery;
import org.apache.lucene.queries.spans.SpanQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.index.query.SpanQueryBuilder;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class SpanContainingQueryBuilder
extends AbstractQueryBuilder<SpanContainingQueryBuilder>
implements SpanQueryBuilder {
    public static final String NAME = "span_containing";
    private static final ParseField BIG_FIELD = new ParseField("big", new String[0]);
    private static final ParseField LITTLE_FIELD = new ParseField("little", new String[0]);
    private final SpanQueryBuilder big;
    private final SpanQueryBuilder little;

    public SpanContainingQueryBuilder(SpanQueryBuilder big, SpanQueryBuilder little) {
        if (big == null) {
            throw new IllegalArgumentException("inner clause [big] cannot be null.");
        }
        if (little == null) {
            throw new IllegalArgumentException("inner clause [little] cannot be null.");
        }
        this.little = little;
        this.big = big;
    }

    public SpanContainingQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.big = (SpanQueryBuilder)in.readNamedWriteable(QueryBuilder.class);
        this.little = (SpanQueryBuilder)in.readNamedWriteable(QueryBuilder.class);
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable(this.big);
        out.writeNamedWriteable(this.little);
    }

    public SpanQueryBuilder bigQuery() {
        return this.big;
    }

    public SpanQueryBuilder littleQuery() {
        return this.little;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.field(BIG_FIELD.getPreferredName());
        this.big.toXContent(builder, params);
        builder.field(LITTLE_FIELD.getPreferredName());
        this.little.toXContent(builder, params);
        this.boostAndQueryNameToXContent(builder);
        builder.endObject();
    }

    public static SpanContainingQueryBuilder fromXContent(XContentParser parser) throws IOException {
        QueryBuilder query;
        XContentParser.Token token;
        float boost = 1.0f;
        String queryName = null;
        SpanQueryBuilder big = null;
        SpanQueryBuilder little = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (BIG_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    query = SpanContainingQueryBuilder.parseInnerQueryBuilder(parser);
                    if (!(query instanceof SpanQueryBuilder)) {
                        throw new ParsingException(parser.getTokenLocation(), "span_containing [big] must be of type span query", new Object[0]);
                    }
                    big = query;
                    SpanQueryBuilder.SpanQueryBuilderUtil.checkNoBoost(NAME, currentFieldName, parser, big);
                    continue;
                }
                if (LITTLE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    query = SpanContainingQueryBuilder.parseInnerQueryBuilder(parser);
                    if (!(query instanceof SpanQueryBuilder)) {
                        throw new ParsingException(parser.getTokenLocation(), "span_containing [little] must be of type span query", new Object[0]);
                    }
                    little = query;
                    SpanQueryBuilder.SpanQueryBuilderUtil.checkNoBoost(NAME, currentFieldName, parser, little);
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "[span_containing] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            if (AbstractQueryBuilder.BOOST_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                boost = parser.floatValue();
                continue;
            }
            if (AbstractQueryBuilder.NAME_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                queryName = parser.text();
                continue;
            }
            throw new ParsingException(parser.getTokenLocation(), "[span_containing] query does not support [" + currentFieldName + "]", new Object[0]);
        }
        query = new SpanContainingQueryBuilder(big, little);
        ((SpanContainingQueryBuilder)query.boost(boost)).queryName(queryName);
        return query;
    }

    @Override
    protected Query doToQuery(SearchExecutionContext context) throws IOException {
        Query innerBig = this.big.toQuery(context);
        assert (innerBig instanceof SpanQuery);
        Query innerLittle = this.little.toQuery(context);
        assert (innerLittle instanceof SpanQuery);
        return new SpanContainingQuery((SpanQuery)innerBig, (SpanQuery)innerLittle);
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.big, this.little);
    }

    @Override
    protected boolean doEquals(SpanContainingQueryBuilder other) {
        return Objects.equals(this.big, other.big) && Objects.equals(this.little, other.little);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.ZERO;
    }
}

