/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http;

import java.io.OutputStream;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.ReferenceDocs;
import org.elasticsearch.common.logging.ChunkedLoggingStream;
import org.elasticsearch.transport.NetworkTraceFlag;

public class HttpBodyTracer {
    private static final Logger logger = LogManager.getLogger(HttpBodyTracer.class);

    public static boolean isEnabled() {
        return logger.isTraceEnabled();
    }

    static OutputStream getBodyOutputStream(long requestId, Type type) {
        block3: {
            try {
                if (NetworkTraceFlag.TRACE_ENABLED) {
                    return ChunkedLoggingStream.create(logger, Level.TRACE, "[" + requestId + "] " + type.text + " body", ReferenceDocs.HTTP_TRACER);
                }
                logger.trace("set system property [{}] to [true] to enable HTTP body tracing", (Object)"es.insecure_network_trace_enabled");
            }
            catch (Exception e) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError((Object)e);
            }
        }
        return OutputStream.nullOutputStream();
    }

    static enum Type {
        REQUEST("request"),
        RESPONSE("response");

        final String text;

        private Type(String text) {
            this.text = text;
        }
    }
}

