/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class CgroupCpuStat
implements JsonpSerializable {
    @Nullable
    private final Long numberOfElapsedPeriods;
    @Nullable
    private final Long numberOfTimesThrottled;
    @Nullable
    private final Long timeThrottledNanos;
    public static final JsonpDeserializer<CgroupCpuStat> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CgroupCpuStat::setupCgroupCpuStatDeserializer);

    private CgroupCpuStat(Builder builder) {
        this.numberOfElapsedPeriods = builder.numberOfElapsedPeriods;
        this.numberOfTimesThrottled = builder.numberOfTimesThrottled;
        this.timeThrottledNanos = builder.timeThrottledNanos;
    }

    public static CgroupCpuStat of(Function<Builder, ObjectBuilder<CgroupCpuStat>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Long numberOfElapsedPeriods() {
        return this.numberOfElapsedPeriods;
    }

    @Nullable
    public final Long numberOfTimesThrottled() {
        return this.numberOfTimesThrottled;
    }

    @Nullable
    public final Long timeThrottledNanos() {
        return this.timeThrottledNanos;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.numberOfElapsedPeriods != null) {
            generator.writeKey("number_of_elapsed_periods");
            generator.write(this.numberOfElapsedPeriods);
        }
        if (this.numberOfTimesThrottled != null) {
            generator.writeKey("number_of_times_throttled");
            generator.write(this.numberOfTimesThrottled);
        }
        if (this.timeThrottledNanos != null) {
            generator.writeKey("time_throttled_nanos");
            generator.write(this.timeThrottledNanos);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupCgroupCpuStatDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::numberOfElapsedPeriods, JsonpDeserializer.longDeserializer(), "number_of_elapsed_periods");
        op.add(Builder::numberOfTimesThrottled, JsonpDeserializer.longDeserializer(), "number_of_times_throttled");
        op.add(Builder::timeThrottledNanos, JsonpDeserializer.longDeserializer(), "time_throttled_nanos");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<CgroupCpuStat> {
        @Nullable
        private Long numberOfElapsedPeriods;
        @Nullable
        private Long numberOfTimesThrottled;
        @Nullable
        private Long timeThrottledNanos;

        public final Builder numberOfElapsedPeriods(@Nullable Long value) {
            this.numberOfElapsedPeriods = value;
            return this;
        }

        public final Builder numberOfTimesThrottled(@Nullable Long value) {
            this.numberOfTimesThrottled = value;
            return this;
        }

        public final Builder timeThrottledNanos(@Nullable Long value) {
            this.timeThrottledNanos = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public CgroupCpuStat build() {
            this._checkSingleUse();
            return new CgroupCpuStat(this);
        }
    }
}

