/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class SlicedScroll
implements JsonpSerializable {
    @Nullable
    private final String field;
    private final String id;
    private final int max;
    public static final JsonpDeserializer<SlicedScroll> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SlicedScroll::setupSlicedScrollDeserializer);

    private SlicedScroll(Builder builder) {
        this.field = builder.field;
        this.id = ApiTypeHelper.requireNonNull(builder.id, this, "id");
        this.max = ApiTypeHelper.requireNonNull(builder.max, (Object)this, "max", 0);
    }

    public static SlicedScroll of(Function<Builder, ObjectBuilder<SlicedScroll>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String field() {
        return this.field;
    }

    public final String id() {
        return this.id;
    }

    public final int max() {
        return this.max;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.field != null) {
            generator.writeKey("field");
            generator.write(this.field);
        }
        generator.writeKey("id");
        generator.write(this.id);
        generator.writeKey("max");
        generator.write(this.max);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupSlicedScrollDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "id");
        op.add(Builder::max, JsonpDeserializer.integerDeserializer(), "max");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<SlicedScroll> {
        @Nullable
        private String field;
        private String id;
        private Integer max;

        public final Builder field(@Nullable String value) {
            this.field = value;
            return this;
        }

        public final Builder id(String value) {
            this.id = value;
            return this;
        }

        public final Builder max(int value) {
            this.max = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SlicedScroll build() {
            this._checkSingleUse();
            return new SlicedScroll(this);
        }
    }
}

