/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.synonyms;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class SynonymSetSummary
implements Writeable,
ToXContentObject {
    public static final String NAME_FIELD = "synonyms_set";
    public static final String COUNT_FIELD = "count";
    private final String name;
    private final long count;

    public SynonymSetSummary(long count, String name) {
        this.name = name;
        this.count = count;
    }

    public SynonymSetSummary(StreamInput in) throws IOException {
        this.name = in.readString();
        this.count = in.readVLong();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(NAME_FIELD, this.name);
        builder.field(COUNT_FIELD, this.count);
        builder.endObject();
        return builder;
    }

    public String name() {
        return this.name;
    }

    public long count() {
        return this.count;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeVLong(this.count);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SynonymSetSummary that = (SynonymSetSummary)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.count, that.count);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.count);
    }
}

