/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.update;

import java.io.IOException;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.support.replication.ReplicationResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.get.GetResult;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class UpdateResponse
extends DocWriteResponse {
    static final String GET = "get";
    private GetResult getResult;

    public UpdateResponse(ShardId shardId, StreamInput in) throws IOException {
        super(shardId, in);
        if (in.readBoolean()) {
            this.getResult = new GetResult(in);
        }
    }

    public UpdateResponse(StreamInput in) throws IOException {
        super(in);
        if (in.readBoolean()) {
            this.getResult = new GetResult(in);
        }
    }

    public UpdateResponse(ShardId shardId, String id, long seqNo, long primaryTerm, long version, DocWriteResponse.Result result) {
        this(ReplicationResponse.ShardInfo.EMPTY, shardId, id, seqNo, primaryTerm, version, result);
    }

    public UpdateResponse(ReplicationResponse.ShardInfo shardInfo, ShardId shardId, String id, long seqNo, long primaryTerm, long version, DocWriteResponse.Result result) {
        super(shardId, id, seqNo, primaryTerm, version, result);
        this.setShardInfo(shardInfo);
    }

    public void setGetResult(GetResult getResult) {
        this.getResult = getResult;
    }

    public GetResult getGetResult() {
        return this.getResult;
    }

    @Override
    public RestStatus status() {
        return this.result == DocWriteResponse.Result.CREATED ? RestStatus.CREATED : super.status();
    }

    @Override
    public void writeThin(StreamOutput out) throws IOException {
        super.writeThin(out);
        this.writeGetResult(out);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.writeGetResult(out);
    }

    private void writeGetResult(StreamOutput out) throws IOException {
        if (this.getResult == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.getResult.writeTo(out);
        }
    }

    @Override
    public XContentBuilder innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        super.innerToXContent(builder, params);
        if (this.getGetResult() != null) {
            builder.startObject(GET);
            this.getGetResult().toXContentEmbedded(builder, params);
            builder.endObject();
        }
        return builder;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("UpdateResponse[");
        builder.append("index=").append(this.getIndex());
        builder.append(",id=").append(this.getId());
        builder.append(",version=").append(this.getVersion());
        builder.append(",seqNo=").append(this.getSeqNo());
        builder.append(",primaryTerm=").append(this.getPrimaryTerm());
        builder.append(",result=").append(this.getResult().getLowercase());
        builder.append(",shards=").append(this.getShardInfo());
        return builder.append("]").toString();
    }

    public static class Builder
    extends DocWriteResponse.Builder {
        private GetResult getResult = null;

        public void setGetResult(GetResult getResult) {
            this.getResult = getResult;
        }

        @Override
        public UpdateResponse build() {
            UpdateResponse update = this.shardInfo != null ? new UpdateResponse(this.shardInfo, this.shardId, this.id, this.seqNo, this.primaryTerm, this.version, this.result) : new UpdateResponse(this.shardId, this.id, this.seqNo, this.primaryTerm, this.version, this.result);
            if (this.getResult != null) {
                update.setGetResult(new GetResult(update.getIndex(), update.getId(), this.getResult.getSeqNo(), this.getResult.getPrimaryTerm(), update.getVersion(), this.getResult.isExists(), this.getResult.internalSourceRef(), this.getResult.getDocumentFields(), this.getResult.getMetadataFields()));
            }
            update.setForcedRefresh(this.forcedRefresh);
            return update;
        }
    }
}

