/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.termvectors;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.termvectors.MultiTermVectorsResponse;
import org.elasticsearch.action.termvectors.TermVectorsResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class MultiTermVectorsShardResponse
extends ActionResponse {
    final List<Integer> locations;
    final List<TermVectorsResponse> responses;
    final List<MultiTermVectorsResponse.Failure> failures;

    MultiTermVectorsShardResponse() {
        this.locations = new ArrayList<Integer>();
        this.responses = new ArrayList<TermVectorsResponse>();
        this.failures = new ArrayList<MultiTermVectorsResponse.Failure>();
    }

    MultiTermVectorsShardResponse(StreamInput in) throws IOException {
        int size = in.readVInt();
        this.locations = new ArrayList<Integer>(size);
        this.responses = new ArrayList<TermVectorsResponse>(size);
        this.failures = new ArrayList<MultiTermVectorsResponse.Failure>(size);
        for (int i = 0; i < size; ++i) {
            this.locations.add(in.readVInt());
            if (in.readBoolean()) {
                this.responses.add(new TermVectorsResponse(in));
            } else {
                this.responses.add(null);
            }
            if (in.readBoolean()) {
                this.failures.add(new MultiTermVectorsResponse.Failure(in));
                continue;
            }
            this.failures.add(null);
        }
    }

    public void add(int location, TermVectorsResponse response) {
        this.locations.add(location);
        this.responses.add(response);
        this.failures.add(null);
    }

    public void add(int location, MultiTermVectorsResponse.Failure failure) {
        this.locations.add(location);
        this.responses.add(null);
        this.failures.add(failure);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.locations.size());
        for (int i = 0; i < this.locations.size(); ++i) {
            out.writeVInt(this.locations.get(i));
            if (this.responses.get(i) == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                this.responses.get(i).writeTo(out);
            }
            if (this.failures.get(i) == null) {
                out.writeBoolean(false);
                continue;
            }
            out.writeBoolean(true);
            this.failures.get(i).writeTo(out);
        }
    }
}

