/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ilm;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class AllocateAction
implements JsonpSerializable {
    @Nullable
    private final Integer numberOfReplicas;
    @Nullable
    private final Integer totalShardsPerNode;
    private final Map<String, String> include;
    private final Map<String, String> exclude;
    private final Map<String, String> require;
    public static final JsonpDeserializer<AllocateAction> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AllocateAction::setupAllocateActionDeserializer);

    private AllocateAction(Builder builder) {
        this.numberOfReplicas = builder.numberOfReplicas;
        this.totalShardsPerNode = builder.totalShardsPerNode;
        this.include = ApiTypeHelper.unmodifiable(builder.include);
        this.exclude = ApiTypeHelper.unmodifiable(builder.exclude);
        this.require = ApiTypeHelper.unmodifiable(builder.require);
    }

    public static AllocateAction of(Function<Builder, ObjectBuilder<AllocateAction>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Integer numberOfReplicas() {
        return this.numberOfReplicas;
    }

    @Nullable
    public final Integer totalShardsPerNode() {
        return this.totalShardsPerNode;
    }

    public final Map<String, String> include() {
        return this.include;
    }

    public final Map<String, String> exclude() {
        return this.exclude;
    }

    public final Map<String, String> require() {
        return this.require;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.numberOfReplicas != null) {
            generator.writeKey("number_of_replicas");
            generator.write(this.numberOfReplicas);
        }
        if (this.totalShardsPerNode != null) {
            generator.writeKey("total_shards_per_node");
            generator.write(this.totalShardsPerNode);
        }
        if (ApiTypeHelper.isDefined(this.include)) {
            generator.writeKey("include");
            generator.writeStartObject();
            for (Map.Entry<String, String> item0 : this.include.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.write(item0.getValue());
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.exclude)) {
            generator.writeKey("exclude");
            generator.writeStartObject();
            for (Map.Entry<String, String> item0 : this.exclude.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.write(item0.getValue());
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.require)) {
            generator.writeKey("require");
            generator.writeStartObject();
            for (Map.Entry<String, String> item0 : this.require.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.write(item0.getValue());
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupAllocateActionDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::numberOfReplicas, JsonpDeserializer.integerDeserializer(), "number_of_replicas");
        op.add(Builder::totalShardsPerNode, JsonpDeserializer.integerDeserializer(), "total_shards_per_node");
        op.add(Builder::include, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "include");
        op.add(Builder::exclude, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "exclude");
        op.add(Builder::require, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "require");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<AllocateAction> {
        @Nullable
        private Integer numberOfReplicas;
        @Nullable
        private Integer totalShardsPerNode;
        @Nullable
        private Map<String, String> include;
        @Nullable
        private Map<String, String> exclude;
        @Nullable
        private Map<String, String> require;

        public final Builder numberOfReplicas(@Nullable Integer value) {
            this.numberOfReplicas = value;
            return this;
        }

        public final Builder totalShardsPerNode(@Nullable Integer value) {
            this.totalShardsPerNode = value;
            return this;
        }

        public final Builder include(Map<String, String> map) {
            this.include = Builder._mapPutAll(this.include, map);
            return this;
        }

        public final Builder include(String key, String value) {
            this.include = Builder._mapPut(this.include, key, value);
            return this;
        }

        public final Builder exclude(Map<String, String> map) {
            this.exclude = Builder._mapPutAll(this.exclude, map);
            return this;
        }

        public final Builder exclude(String key, String value) {
            this.exclude = Builder._mapPut(this.exclude, key, value);
            return this;
        }

        public final Builder require(Map<String, String> map) {
            this.require = Builder._mapPutAll(this.require, map);
            return this;
        }

        public final Builder require(String key, String value) {
            this.require = Builder._mapPut(this.require, key, value);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public AllocateAction build() {
            this._checkSingleUse();
            return new AllocateAction(this);
        }
    }
}

