/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryBase;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.elasticsearch._types.query_dsl.ZeroTermsQuery;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class MatchPhraseQuery
extends QueryBase
implements QueryVariant {
    private final String field;
    @Nullable
    private final String analyzer;
    private final String query;
    @Nullable
    private final Integer slop;
    @Nullable
    private final ZeroTermsQuery zeroTermsQuery;
    public static final JsonpDeserializer<MatchPhraseQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MatchPhraseQuery::setupMatchPhraseQueryDeserializer);

    private MatchPhraseQuery(Builder builder) {
        super(builder);
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.analyzer = builder.analyzer;
        this.query = ApiTypeHelper.requireNonNull(builder.query, this, "query");
        this.slop = builder.slop;
        this.zeroTermsQuery = builder.zeroTermsQuery;
    }

    public static MatchPhraseQuery of(Function<Builder, ObjectBuilder<MatchPhraseQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.MatchPhrase;
    }

    public final String field() {
        return this.field;
    }

    @Nullable
    public final String analyzer() {
        return this.analyzer;
    }

    public final String query() {
        return this.query;
    }

    @Nullable
    public final Integer slop() {
        return this.slop;
    }

    @Nullable
    public final ZeroTermsQuery zeroTermsQuery() {
        return this.zeroTermsQuery;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject(this.field);
        super.serializeInternal(generator, mapper);
        if (this.analyzer != null) {
            generator.writeKey("analyzer");
            generator.write(this.analyzer);
        }
        generator.writeKey("query");
        generator.write(this.query);
        if (this.slop != null) {
            generator.writeKey("slop");
            generator.write(this.slop);
        }
        if (this.zeroTermsQuery != null) {
            generator.writeKey("zero_terms_query");
            this.zeroTermsQuery.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupMatchPhraseQueryDeserializer(ObjectDeserializer<Builder> op) {
        QueryBase.setupQueryBaseDeserializer(op);
        op.add(Builder::analyzer, JsonpDeserializer.stringDeserializer(), "analyzer");
        op.add(Builder::query, JsonpDeserializer.stringDeserializer(), "query");
        op.add(Builder::slop, JsonpDeserializer.integerDeserializer(), "slop");
        op.add(Builder::zeroTermsQuery, ZeroTermsQuery._DESERIALIZER, "zero_terms_query");
        op.setKey(Builder::field, JsonpDeserializer.stringDeserializer());
        op.shortcutProperty("query");
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<MatchPhraseQuery> {
        private String field;
        @Nullable
        private String analyzer;
        private String query;
        @Nullable
        private Integer slop;
        @Nullable
        private ZeroTermsQuery zeroTermsQuery;

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder analyzer(@Nullable String value) {
            this.analyzer = value;
            return this;
        }

        public final Builder query(String value) {
            this.query = value;
            return this;
        }

        public final Builder slop(@Nullable Integer value) {
            this.slop = value;
            return this;
        }

        public final Builder zeroTermsQuery(@Nullable ZeroTermsQuery value) {
            this.zeroTermsQuery = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public MatchPhraseQuery build() {
            this._checkSingleUse();
            return new MatchPhraseQuery(this);
        }
    }
}

