/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ocsp.ResponderID;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.util.io.Streams;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class OCSPStatusRequest {
    protected Vector responderIDList;
    protected Extensions requestExtensions;

    public OCSPStatusRequest(Vector vector, Extensions extensions) {
        this.responderIDList = vector;
        this.requestExtensions = extensions;
    }

    public Vector getResponderIDList() {
        return this.responderIDList;
    }

    public Extensions getRequestExtensions() {
        return this.requestExtensions;
    }

    public void encode(OutputStream outputStream) throws IOException {
        Object object;
        if (this.responderIDList == null || this.responderIDList.isEmpty()) {
            TlsUtils.writeUint16(0, outputStream);
        } else {
            object = new ByteArrayOutputStream();
            for (int i = 0; i < this.responderIDList.size(); ++i) {
                ResponderID responderID = (ResponderID)this.responderIDList.elementAt(i);
                byte[] byArray = responderID.getEncoded("DER");
                TlsUtils.writeOpaque16(byArray, (OutputStream)object);
            }
            TlsUtils.checkUint16(((ByteArrayOutputStream)object).size());
            TlsUtils.writeUint16(((ByteArrayOutputStream)object).size(), outputStream);
            Streams.writeBufTo((ByteArrayOutputStream)object, (OutputStream)outputStream);
        }
        if (this.requestExtensions == null) {
            TlsUtils.writeUint16(0, outputStream);
        } else {
            object = this.requestExtensions.getEncoded("DER");
            TlsUtils.checkUint16(((Object)object).length);
            TlsUtils.writeUint16(((Object)object).length, outputStream);
            outputStream.write((byte[])object);
        }
    }

    public static OCSPStatusRequest parse(InputStream inputStream) throws IOException {
        ASN1Primitive aSN1Primitive;
        Object object;
        Object object2;
        Vector<ResponderID> vector = new Vector<ResponderID>();
        Object object3 = TlsUtils.readOpaque16(inputStream);
        if (((byte[])object3).length > 0) {
            object2 = new ByteArrayInputStream((byte[])object3);
            do {
                object = TlsUtils.readOpaque16((InputStream)object2, 1);
                aSN1Primitive = TlsUtils.readASN1Object(object);
                ResponderID responderID = ResponderID.getInstance((Object)aSN1Primitive);
                TlsUtils.requireDEREncoding((ASN1Object)responderID, object);
                vector.addElement(responderID);
            } while (((ByteArrayInputStream)object2).available() > 0);
        }
        object3 = null;
        object2 = TlsUtils.readOpaque16(inputStream);
        if (((Object)object2).length > 0) {
            object = TlsUtils.readASN1Object((byte[])object2);
            aSN1Primitive = Extensions.getInstance((Object)object);
            TlsUtils.requireDEREncoding((ASN1Object)aSN1Primitive, (byte[])object2);
            object3 = aSN1Primitive;
        }
        return new OCSPStatusRequest(vector, (Extensions)object3);
    }
}

