"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertSummaryWidgetCompact = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _charts = require("@elastic/charts");
var _i18n = require("@kbn/i18n");
var _alert_counts = require("./alert_counts");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AlertSummaryWidgetCompact = ({
  activeAlertCount,
  activeAlerts,
  chartProps: {
    themeOverrides
  } = {},
  recoveredAlertCount,
  timeRangeTitle,
  onClick,
  dependencyProps: {
    baseTheme,
    sparklineTheme
  }
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const handleClick = (event, status) => {
    event.preventDefault();
    event.stopPropagation();
    onClick(status);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    element: "div",
    "data-test-subj": "alertSummaryWidgetCompact",
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, !!timeRangeTitle && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h5", null, _constants.WIDGET_TITLE)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    "data-test-subj": "timeRangeTitle"
  }, timeRangeTitle)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_alert_counts.AlertCounts, {
    activeAlertCount: activeAlertCount,
    recoveredAlertCount: recoveredAlertCount,
    handleClick: handleClick
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    wrap: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      minWidth: '200px'
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    size: {
      height: 50
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Tooltip, {
    type: _charts.TooltipType.None
  }), /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    theme: [...(themeOverrides ? Array.isArray(themeOverrides) ? themeOverrides : [themeOverrides] : []), sparklineTheme, {
      chartMargins: {
        left: 10,
        right: 10,
        top: 10,
        bottom: 10
      }
    }],
    baseTheme: baseTheme,
    locale: _i18n.i18n.getLocale()
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    hide: true,
    id: "activeAlertsAxis",
    position: _charts.Position.Left,
    gridLine: {
      visible: false
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.LineSeries, {
    id: 'activeAlertsChart'
    // Defaults to multi layer time axis as of Elastic Charts v70
    ,
    xScaleType: _charts.ScaleType.Time,
    yScaleType: _charts.ScaleType.Linear,
    xAccessor: "key",
    yAccessors: ['doc_count'],
    data: activeAlerts,
    lineSeriesStyle: {
      line: {
        strokeWidth: 2,
        stroke: euiTheme.colors.vis.euiColorVis0
      }
    },
    curve: _charts.CurveType.CURVE_MONOTONE_X
  })))))));
};
exports.AlertSummaryWidgetCompact = AlertSummaryWidgetCompact;