"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.resetActionNameText = exports.isResetActionDisabled = exports.getResetActionDisabledMessage = exports.ResetActionName = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _create_stats_unknown_message = require("../../../../../../common/utils/create_stats_unknown_message");
var _transform_list = require("../../../../common/transform_list");
var _constants = require("../../../../../../common/constants");
var _create_capability_failure_message = require("../../../../../../common/utils/create_capability_failure_message");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const resetActionNameText = exports.resetActionNameText = _i18n.i18n.translate('xpack.transform.transformList.resetActionNameText', {
  defaultMessage: 'Reset'
});
const transformCanNotBeReseted = i => i.stats && ![_constants.TRANSFORM_STATE.STOPPED, _constants.TRANSFORM_STATE.FAILED].includes(i.stats.state);
const isResetActionDisabled = (items, forceDisable) => {
  const disabled = items.some(transformCanNotBeReseted);
  return forceDisable === true || disabled || (0, _transform_list.missingTransformStats)(items);
};
exports.isResetActionDisabled = isResetActionDisabled;
const getResetActionDisabledMessage = ({
  items,
  canResetTransform,
  forceDisable
}) => {
  const isBulkAction = items.length > 1;
  if ((0, _transform_list.missingTransformStats)(items)) {
    return (0, _create_stats_unknown_message.createNoStatsTooltipMessage)({
      actionName: resetActionNameText,
      count: items.length
    });
  }
  if (!canResetTransform) {
    return (0, _create_capability_failure_message.createCapabilityFailureMessage)('canResetTransform');
  }
  if (isResetActionDisabled(items, forceDisable)) {
    const bulkResetButtonDisabledText = _i18n.i18n.translate('xpack.transform.transformList.resetBulkActionDisabledToolTipContent', {
      defaultMessage: 'One or more selected transforms must be stopped to be reset.'
    });
    const resetButtonDisabledText = _i18n.i18n.translate('xpack.transform.transformList.resetActionDisabledToolTipContent', {
      defaultMessage: 'Stop the transform in order to reset it.'
    });
    return isBulkAction ? bulkResetButtonDisabledText : resetButtonDisabledText;
  }
};
exports.getResetActionDisabledMessage = getResetActionDisabledMessage;
const ResetActionName = ({
  items,
  canResetTransform,
  disabled
}) => {
  const content = getResetActionDisabledMessage({
    items,
    canResetTransform,
    forceDisable: disabled
  });
  if (content) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: content
    }, /*#__PURE__*/_react.default.createElement("span", {
      tabIndex: 0
    }, resetActionNameText));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, resetActionNameText);
};
exports.ResetActionName = ResetActionName;