"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createJourneyScreenshotBlocksRoute = void 0;
var _configSchema = require("@kbn/config-schema");
var _get_journey_screenshot_blocks = require("../../queries/get_journey_screenshot_blocks");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createJourneyScreenshotBlocksRoute = () => ({
  method: 'POST',
  path: _constants.SYNTHETICS_API_URLS.JOURNEY_SCREENSHOT_BLOCKS,
  validate: {
    body: _configSchema.schema.object({
      hashes: _configSchema.schema.arrayOf(_configSchema.schema.string())
    })
  },
  writeAccess: false,
  handler: async ({
    request,
    syntheticsEsClient
  }) => {
    const {
      hashes: blockIds
    } = request.body;
    const result = await (0, _get_journey_screenshot_blocks.getJourneyScreenshotBlocks)({
      blockIds,
      syntheticsEsClient
    });
    return {
      result
    };
  }
});
exports.createJourneyScreenshotBlocksRoute = createJourneyScreenshotBlocksRoute;