"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorStatusCol = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _date_util = require("../../../../../../../../../common/utils/date_util");
var _runtime_types = require("../../../../../../../../../common/runtime_types");
var _monitor_status = require("../../../../../common/components/monitor_status");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MonitorStatusCol = ({
  monitor,
  openFlyout
}) => {
  const timestamp = monitor.timestamp ? (0, _date_util.parseTimestamp)(monitor.timestamp) : null;
  return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_monitor_status.BadgeStatus, {
    status: monitor.status,
    isBrowserType: monitor.type === _runtime_types.MonitorTypeEnum.BROWSER,
    onClickBadge: () => openFlyout(monitor)
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), timestamp ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "text",
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("strong", null, " ", timestamp.fromNow())), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      margin: "xs"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "ghost",
      size: "xs"
    }, timestamp.toLocaleString()))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    tabIndex: 0,
    size: "xs",
    color: "subdued",
    className: "eui-textNoWrap"
  }, getCheckedLabel(timestamp))) : '--');
};
exports.MonitorStatusCol = MonitorStatusCol;
const getCheckedLabel = timestamp => {
  return _i18n.i18n.translate('xpack.synthetics.monitorList.statusColumn.checkedTimestamp', {
    defaultMessage: 'Checked {timestamp}',
    values: {
      timestamp: (0, _date_util.getShortTimeStamp)(timestamp)
    }
  });
};