"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRecentlyViewedMonitors = void 0;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/observability-shared-plugin/public");
var _useLocalStorage = _interopRequireDefault(require("react-use/lib/useLocalStorage"));
var _use_monitor_query_id = require("../hooks/use_monitor_query_id");
var _state = require("../../../state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HISTORY_LENGTH = 5;
const useRecentlyViewedMonitors = () => {
  const [recentlyViewedMonitorQueryIds, setRecentlyViewedMonitorQueryIds] = (0, _useLocalStorage.default)('xpack.synthetics.recentlyViewedMonitors', []);
  const fetchedMonitorsRef = (0, _react.useRef)([]);
  const monitorQueryId = (0, _use_monitor_query_id.useMonitorQueryId)();
  const fetchedMonitorQueryIdsSnap = JSON.stringify([...fetchedMonitorsRef.current.map(({
    key
  }) => key)].sort());
  const updateRecentlyViewed = (0, _react.useCallback)(() => {
    const updatedIdsToPersist = fetchedMonitorsRef.current.length ? fetchedMonitorsRef.current.map(({
      monitorQueryId: id
    }) => id) : recentlyViewedMonitorQueryIds !== null && recentlyViewedMonitorQueryIds !== void 0 ? recentlyViewedMonitorQueryIds : [];
    if (monitorQueryId) {
      setRecentlyViewedMonitorQueryIds([monitorQueryId, ...updatedIdsToPersist].filter((id, index, arr) => arr.indexOf(id) === index).slice(0, HISTORY_LENGTH));
    }
    // Exclude `recentlyViewedMonitorQueryIds`
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [setRecentlyViewedMonitorQueryIds, monitorQueryId, fetchedMonitorQueryIdsSnap]);
  (0, _react.useEffect)(() => {
    updateRecentlyViewed();
  }, [updateRecentlyViewed, monitorQueryId]);
  const {
    loading
  } = (0, _public.useFetcher)(async () => {
    const monitorQueryIdsToFetch = (recentlyViewedMonitorQueryIds !== null && recentlyViewedMonitorQueryIds !== void 0 ? recentlyViewedMonitorQueryIds : []).filter(id => id !== monitorQueryId);
    if (monitorQueryId && monitorQueryIdsToFetch.length && JSON.stringify([...monitorQueryIdsToFetch].sort()) !== fetchedMonitorQueryIdsSnap) {
      var _fetchedResult$monito;
      const fetchedResult = await (0, _state.fetchMonitorManagementList)((0, _state.getMonitorListPageStateWithDefaults)({
        pageSize: HISTORY_LENGTH,
        monitorQueryIds: monitorQueryIdsToFetch
      }));
      if (fetchedResult !== null && fetchedResult !== void 0 && (_fetchedResult$monito = fetchedResult.monitors) !== null && _fetchedResult$monito !== void 0 && _fetchedResult$monito.length) {
        const persistedOrderHash = monitorQueryIdsToFetch.reduce((acc, cur, index) => ({
          ...acc,
          [cur]: index
        }), {});

        // Reorder fetched monitors as per the persisted order
        const fetchedMonitorsInPersistedOrder = [...(fetchedResult === null || fetchedResult === void 0 ? void 0 : fetchedResult.monitors)].sort((a, b) => persistedOrderHash[a.id] - persistedOrderHash[b.id]);
        fetchedMonitorsRef.current = fetchedMonitorsInPersistedOrder.map(mon => {
          var _mon$locations;
          return {
            key: mon.id,
            monitorQueryId: mon.id,
            label: mon.name,
            locationIds: ((_mon$locations = mon.locations) !== null && _mon$locations !== void 0 ? _mon$locations : []).map(({
              id
            }) => id),
            isGroupLabel: false
          };
        });
        updateRecentlyViewed();
      }
    }
    // FIXME: Dario thinks there is a better way to do this but
    // he's getting tired and maybe the Synthetics folks can fix it
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [monitorQueryId]);
  return (0, _react.useMemo)(() => ({
    loading,
    recentMonitorOptions: fetchedMonitorsRef.current.length ? [{
      key: 'recently_viewed',
      label: RECENTLY_VIEWED,
      isGroupLabel: true
    }, ...fetchedMonitorsRef.current] : []
  }),
  // Make it also depend on `fetchedMonitorQueryIdsSnap`
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [loading, fetchedMonitorQueryIdsSnap]);
};
exports.useRecentlyViewedMonitors = useRecentlyViewedMonitors;
const RECENTLY_VIEWED = _i18n.i18n.translate('xpack.synthetics.monitorSummary.recentlyViewed', {
  defaultMessage: 'Recently viewed'
});