"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WindowValueExpression = void 0;
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _popover_expression = require("./popover_expression");
var _status_rule = require("../../../../../../common/rules/status_rule");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const WindowValueExpression = ({
  ruleParams,
  setRuleParams
}) => {
  var _condition$window$tim, _timeWindow$size, _timeWindow$unit;
  const {
    condition
  } = ruleParams;
  const timeWindow = condition && 'time' in condition.window ? (_condition$window$tim = condition.window.time) !== null && _condition$window$tim !== void 0 ? _condition$window$tim : {
    size: 5,
    unit: 'm'
  } : null;
  const timeWindowSize = (_timeWindow$size = timeWindow === null || timeWindow === void 0 ? void 0 : timeWindow.size) !== null && _timeWindow$size !== void 0 ? _timeWindow$size : 5;
  const timeWindowUnit = (_timeWindow$unit = timeWindow === null || timeWindow === void 0 ? void 0 : timeWindow.unit) !== null && _timeWindow$unit !== void 0 ? _timeWindow$unit : 'm';
  const numberOfChecks = condition && 'numberOfChecks' in condition.window ? condition.window.numberOfChecks : null;
  const {
    useTimeWindow
  } = (0, _status_rule.getConditionType)(ruleParams.condition);
  const onTimeWindowChange = (0, _react.useCallback)(value => {
    var _ruleParams$condition;
    setRuleParams('condition', {
      ...ruleParams.condition,
      window: {
        ...((_ruleParams$condition = ruleParams.condition) === null || _ruleParams$condition === void 0 ? void 0 : _ruleParams$condition.window),
        time: value
      }
    });
  }, [ruleParams.condition, setRuleParams]);
  const onNumberOfChecksChange = (0, _react.useCallback)(value => {
    var _ruleParams$condition2;
    setRuleParams('condition', {
      ...ruleParams.condition,
      window: {
        ...((_ruleParams$condition2 = ruleParams.condition) === null || _ruleParams$condition2 === void 0 ? void 0 : _ruleParams$condition2.window),
        numberOfChecks: value
      }
    });
  }, [ruleParams.condition, setRuleParams]);
  if (!useTimeWindow) {
    return /*#__PURE__*/_react.default.createElement(_popover_expression.PopoverExpression, {
      value: (numberOfChecks !== null && numberOfChecks !== void 0 ? numberOfChecks : 5) + _i18n.i18n.translate('xpack.synthetics.windowValueExpression.checksLabel', {
        defaultMessage: ' checks'
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, null, _i18n.i18n.translate('xpack.synthetics.windowValueExpression.numberOfChecksPopoverTitleLabel', {
      defaultMessage: 'Number of checks'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
      "data-test-subj": "syntheticsWindowValueExpressionFieldNumber",
      min: 1,
      max: 10,
      compressed: true,
      value: numberOfChecks !== null && numberOfChecks !== void 0 ? numberOfChecks : 5,
      onChange: evt => onNumberOfChecksChange(Number(evt.target.value))
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_public.ForLastExpression, {
    timeWindowSize: timeWindowSize,
    timeWindowUnit: timeWindowUnit,
    onChangeWindowSize: val => {
      onTimeWindowChange({
        size: val !== null && val !== void 0 ? val : 5,
        unit: timeWindowUnit
      });
    },
    onChangeWindowUnit: val => {
      onTimeWindowChange({
        size: timeWindowSize,
        unit: val !== null && val !== void 0 ? val : 'm'
      });
    },
    errors: {},
    description: ""
  });
};
exports.WindowValueExpression = WindowValueExpression;