"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEffectiveLifecycle = getEffectiveLifecycle;
var _streamsSchema = require("@kbn/streams-schema");
var _stream_crud = require("../stream_crud");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getEffectiveLifecycle({
  definition,
  streamsClient,
  dataStream
}) {
  if (_streamsSchema.Streams.UnwiredStream.Definition.is(definition)) {
    return (0, _stream_crud.getDataStreamLifecycle)(dataStream);
  }
  if ((0, _streamsSchema.isInheritLifecycle)(definition.ingest.lifecycle)) {
    const ancestors = await streamsClient.getAncestors(definition.name);
    return (0, _streamsSchema.findInheritedLifecycle)(definition, ancestors);
  }
  return definition.ingest.lifecycle;
}