"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ContentService = void 0;
var _storageAdapter = require("@kbn/storage-adapter");
var _content_client = require("./content_client");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ContentService {
  constructor(coreSetup, logger) {
    this.coreSetup = coreSetup;
    this.logger = logger;
  }
  async getClient() {
    const [coreStart] = await this.coreSetup.getStartServices();
    const adapter = new _storageAdapter.StorageIndexAdapter(coreStart.elasticsearch.client.asInternalUser, this.logger.get('content'), _content_client.contentStorageSettings);
    return new _content_client.ContentClient({
      storageClient: adapter.getClient()
    });
  }
}
exports.ContentService = ContentService;