"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StreamsAppPageTemplate = StreamsAppPageTemplate;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _use_kibana = require("../../hooks/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function StreamsAppPageTemplate({
  children
}) {
  const {
    services: {
      PageTemplate
    }
  } = (0, _use_kibana.useKibana)();

  /**
   * This template wrapper only serves the purpose of adding the o11y sidebar to the app.
   * Due to the dependency inversion used to get the template and the constrain on the dependencies imports,
   * we cannot get the right types for this template unless its definition gets moved into a more generic package.
   */
  return /*#__PURE__*/_react.default.createElement(PageTemplate, null, children);
}
StreamsAppPageTemplate.Header = _eui.EuiPageTemplate.Header;
StreamsAppPageTemplate.EmptyPrompt = _eui.EuiPageTemplate.EmptyPrompt;
StreamsAppPageTemplate.Body = props => /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Section, (0, _extends2.default)({
  grow: true,
  css: (0, _react2.css)`
      overflow-y: auto;
    `,
  contentProps: {
    css: (0, _react2.css)`
        display: flex;
        flex-direction: column;
        height: 100%;
      `
  }
}, props));