"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSparkplotDataFromSigEvents = useSparkplotDataFromSigEvents;
var _eui = require("@elastic/eui");
var _react = require("react");
var _change_point = require("../change_point");
var _get_annotation_from_formatted_change_point = require("../utils/get_annotation_from_formatted_change_point");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useSparkplotDataFromSigEvents({
  previewFetch,
  queryValues,
  xFormatter
}) {
  const theme = (0, _eui.useEuiTheme)().euiTheme;
  return (0, _react.useMemo)(() => {
    var _previewFetch$value, _previewFetch$value2, _occurrences$map;
    const changePoints = (_previewFetch$value = previewFetch.value) === null || _previewFetch$value === void 0 ? void 0 : _previewFetch$value.change_points;
    const occurrences = (_previewFetch$value2 = previewFetch.value) === null || _previewFetch$value2 === void 0 ? void 0 : _previewFetch$value2.occurrences;
    const timeseries = (_occurrences$map = occurrences === null || occurrences === void 0 ? void 0 : occurrences.map(({
      date,
      count
    }) => {
      return {
        x: new Date(date).getTime(),
        y: count
      };
    })) !== null && _occurrences$map !== void 0 ? _occurrences$map : [];
    const {
      id,
      kql,
      title
    } = queryValues;
    const change = changePoints && occurrences && id && kql && title ? (0, _change_point.formatChangePoint)({
      change_points: changePoints,
      occurrences: timeseries,
      query: {
        id,
        kql,
        title
      }
    }) : undefined;
    return {
      timeseries,
      annotations: change ? [(0, _get_annotation_from_formatted_change_point.getAnnotationFromFormattedChangePoint)({
        query: {
          id
        },
        change,
        theme,
        xFormatter
      })] : []
    };
  }, [previewFetch, xFormatter, queryValues, theme]);
}