"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ClassicStreamDetailManagement = ClassicStreamDetailManagement;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _streamsSchema = require("@kbn/streams-schema");
var _eui = require("@elastic/eui");
var _use_streams_app_params = require("../../../hooks/use_streams_app_params");
var _redirect_to = require("../../redirect_to");
var _wrapper = require("./wrapper");
var _stream_detail_lifecycle = require("../stream_detail_lifecycle");
var _unmanaged_elasticsearch_assets = require("./unmanaged_elasticsearch_assets");
var _streams_app_page_template = require("../../streams_app_page_template");
var _stream_badges = require("../../stream_badges");
var _use_streams_detail_management_tabs = require("./use_streams_detail_management_tabs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const classicStreamManagementSubTabs = ['enrich', 'advanced', 'lifecycle', 'significantEvents'];
function isValidManagementSubTab(value) {
  return classicStreamManagementSubTabs.includes(value);
}
function ClassicStreamDetailManagement({
  definition,
  refreshDefinition
}) {
  const {
    path: {
      key,
      tab
    }
  } = (0, _use_streams_app_params.useStreamsAppParams)('/{key}/management/{tab}');
  const {
    enrich,
    ...otherTabs
  } = (0, _use_streams_detail_management_tabs.useStreamsDetailManagementTabs)({
    definition,
    refreshDefinition
  });
  if (!definition.data_stream_exists) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_streams_app_page_template.StreamsAppPageTemplate.Header, {
      bottomBorder: "extended",
      pageTitle: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "s",
        alignItems: "center"
      }, _i18n.i18n.translate('xpack.streams.entityDetailViewWithoutParams.manageStreamTitle', {
        defaultMessage: 'Manage stream {streamId}',
        values: {
          streamId: key
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiBadgeGroup, {
        gutterSize: "s"
      }, _streamsSchema.Streams.UnwiredStream.Definition.is(definition.stream) && /*#__PURE__*/_react.default.createElement(_stream_badges.ClassicStreamBadge, null), /*#__PURE__*/_react.default.createElement(_stream_badges.LifecycleBadge, {
        lifecycle: definition.effective_lifecycle
      })))
    }), /*#__PURE__*/_react.default.createElement(_streams_app_page_template.StreamsAppPageTemplate.Body, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: _i18n.i18n.translate('xpack.streams.unmanagedStreamOverview.missingDatastream.title', {
        defaultMessage: 'Data stream missing'
      }),
      color: "danger",
      iconType: "error"
    }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.streams.unmanagedStreamOverview.missingDatastream.description', {
      defaultMessage: 'The underlying Elasticsearch data stream for this classic stream is missing. Recreate the data stream to restore the stream by sending data before using the management features.'
    })))));
  }
  const tabs = {};
  if (definition.data_stream_exists) {
    tabs.lifecycle = {
      content: /*#__PURE__*/_react.default.createElement(_stream_detail_lifecycle.StreamDetailLifecycle, {
        definition: definition,
        refreshDefinition: refreshDefinition
      }),
      label: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: _i18n.i18n.translate('xpack.streams.managementTab.lifecycle.tooltip', {
          defaultMessage: 'Control how long data stays in this stream. Set a custom duration or apply a shared policy.'
        })
      }, /*#__PURE__*/_react.default.createElement("span", null, _i18n.i18n.translate('xpack.streams.streamDetailView.lifecycleTab', {
        defaultMessage: 'Data retention'
      })))
    };
    tabs.enrich = enrich;
  }
  if (definition.privileges.manage) {
    tabs.advanced = {
      content: /*#__PURE__*/_react.default.createElement(_unmanaged_elasticsearch_assets.UnmanagedElasticsearchAssets, {
        definition: definition,
        refreshDefinition: refreshDefinition
      }),
      label: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: _i18n.i18n.translate('xpack.streams.managementTab.advanced.tooltip', {
          defaultMessage: 'View technical details about this classic stream’s underlying index setup'
        })
      }, /*#__PURE__*/_react.default.createElement("span", null, _i18n.i18n.translate('xpack.streams.streamDetailView.advancedTab', {
        defaultMessage: 'Advanced'
      })))
    };
  }
  if (otherTabs.significantEvents) {
    tabs.significantEvents = otherTabs.significantEvents;
  }
  if (!isValidManagementSubTab(tab)) {
    return /*#__PURE__*/_react.default.createElement(_redirect_to.RedirectTo, {
      path: "/{key}/management/{tab}",
      params: {
        path: {
          key,
          tab: 'enrich'
        }
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_wrapper.Wrapper, {
    tabs: tabs,
    streamId: key,
    tab: tab
  });
}