"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.groupIntoMap = groupIntoMap;
exports.mapValuesOfMap = mapValuesOfMap;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function mapValuesOfMap(map, mapper) {
  const result = new Map();
  for (const [key, value] of map.entries()) {
    result.set(key, mapper(value));
  }
  return result;
}
function groupIntoMap(collection, groupBy) {
  const map = new Map();
  collection.forEach(item => {
    const key = groupBy(item);
    const values = map.get(key) || [];
    values.push(item);
    map.set(key, values);
  });
  return map;
}