"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SSLCertFields = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _components = require("@kbn/es-ui-shared-plugin/static/forms/components");
var _helpers = require("@kbn/es-ui-shared-plugin/static/forms/helpers");
var _constants = require("../../../common/auth/constants");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  emptyField
} = _helpers.fieldValidators;
const SSLCertFields = ({
  readOnly,
  certTypeDefaultValue,
  certType,
  isPfxEnabled = true
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  justifyContent: "spaceBetween",
  "data-test-subj": "sslCertFields"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
  path: "secrets.password",
  config: {
    label: i18n.PASSWORD
  },
  component: _components.PasswordField,
  componentProps: {
    euiFieldProps: {
      'data-test-subj': 'webhookSSLPassphraseInput',
      readOnly
    }
  }
}), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "s"
}), /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
  path: "config.certType",
  defaultValue: certTypeDefaultValue,
  component: ({
    field
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    size: "s",
    "data-test-subj": "webhookCertTypeTabs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    onClick: () => field.setValue(_constants.SSLCertType.CRT),
    isSelected: field.value === _constants.SSLCertType.CRT || !isPfxEnabled,
    "data-test-subj": "webhookCertTypeCRTab"
  }, i18n.CERT_TYPE_CRT_KEY), isPfxEnabled && /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    onClick: () => field.setValue(_constants.SSLCertType.PFX),
    isSelected: field.value === _constants.SSLCertType.PFX,
    "data-test-subj": "webhookCertTypePFXTab"
  }, i18n.CERT_TYPE_PFX))
}), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "s"
}), (!isPfxEnabled || certType === _constants.SSLCertType.CRT) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  wrap: true
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  css: {
    minWidth: 200
  }
}, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
  path: "secrets.crt",
  config: {
    label: 'CRT file',
    validations: [{
      validator: emptyField(i18n.CRT_REQUIRED)
    }]
  },
  component: _components.FilePickerField,
  componentProps: {
    euiFieldProps: {
      'data-test-subj': 'webhookSSLCRTInput',
      display: 'default',
      accept: '.crt,.cert,.cer,.pem'
    }
  }
})), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  css: {
    minWidth: 200
  }
}, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
  path: "secrets.key",
  config: {
    label: 'KEY file',
    validations: [{
      validator: emptyField(i18n.KEY_REQUIRED)
    }]
  },
  component: _components.FilePickerField,
  componentProps: {
    euiFieldProps: {
      'data-test-subj': 'webhookSSLKEYInput',
      display: 'default',
      accept: '.key,.pem'
    }
  }
}))), isPfxEnabled && certType === _constants.SSLCertType.PFX && /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
  path: "secrets.pfx",
  config: {
    label: 'PFX file',
    validations: [{
      validator: emptyField(i18n.PFX_REQUIRED)
    }]
  },
  component: _components.FilePickerField,
  componentProps: {
    euiFieldProps: {
      'data-test-subj': 'webhookSSLPFXInput',
      display: 'default',
      accept: '.pfx,.p12'
    }
  }
})));
exports.SSLCertFields = SSLCertFields;