"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateExpression = void 0;
var _esQuery = require("@kbn/es-query");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/triggers-actions-ui-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const validateExpression = alertParams => {
  const {
    index,
    timeField,
    aggType,
    aggField,
    groupBy,
    termSize,
    termField,
    threshold,
    timeWindowSize,
    thresholdComparator,
    filterKuery
  } = alertParams;
  const validationResult = {
    errors: {}
  };
  const errors = {
    aggField: new Array(),
    termSize: new Array(),
    termField: new Array(),
    timeWindowSize: new Array(),
    threshold0: new Array(),
    threshold1: new Array(),
    index: new Array(),
    timeField: new Array(),
    filterKuery: new Array()
  };
  validationResult.errors = errors;
  if (filterKuery) {
    try {
      (0, _esQuery.toElasticsearchQuery)((0, _esQuery.fromKueryExpression)(filterKuery));
    } catch (e) {
      errors.filterKuery.push(_i18n.i18n.translate('xpack.stackAlerts.threshold.ui.validation.error.invalidKql', {
        defaultMessage: 'Filter query is invalid.'
      }));
    }
  }
  if (!index || index.length === 0) {
    errors.index.push(_i18n.i18n.translate('xpack.stackAlerts.threshold.ui.validation.error.requiredIndexText', {
      defaultMessage: 'Index is required.'
    }));
  }
  if (!timeField) {
    errors.timeField.push(_i18n.i18n.translate('xpack.stackAlerts.threshold.ui.validation.error.requiredTimeFieldText', {
      defaultMessage: 'Time field is required.'
    }));
  }
  if (aggType && _public.builtInAggregationTypes[aggType].fieldRequired && !aggField) {
    errors.aggField.push(_i18n.i18n.translate('xpack.stackAlerts.threshold.ui.validation.error.requiredAggFieldText', {
      defaultMessage: 'Aggregation field is required.'
    }));
  }
  if (groupBy && _public.builtInGroupByTypes[groupBy] && _public.builtInGroupByTypes[groupBy].sizeRequired && !termSize) {
    errors.termSize.push(_i18n.i18n.translate('xpack.stackAlerts.threshold.ui.validation.error.requiredTermSizedText', {
      defaultMessage: 'Term size is required.'
    }));
  }
  if (groupBy && _public.builtInGroupByTypes[groupBy].validNormalizedTypes && _public.builtInGroupByTypes[groupBy].validNormalizedTypes.length > 0 && !termField) {
    errors.termField.push(_i18n.i18n.translate('xpack.stackAlerts.threshold.ui.validation.error.requiredTermFieldText', {
      defaultMessage: 'Term field is required.'
    }));
  }
  if (!timeWindowSize) {
    errors.timeWindowSize.push(_i18n.i18n.translate('xpack.stackAlerts.threshold.ui.validation.error.requiredTimeWindowSizeText', {
      defaultMessage: 'Time window size is required.'
    }));
  }
  if (!threshold || threshold.length === 0 || threshold[0] === undefined) {
    errors.threshold0.push(_i18n.i18n.translate('xpack.stackAlerts.threshold.ui.validation.error.requiredThreshold0Text', {
      defaultMessage: 'Threshold0 is required.'
    }));
  }
  if (thresholdComparator && _public.builtInComparators[thresholdComparator].requiredValues > 1 && (!threshold || threshold[1] === undefined || threshold && threshold.length < _public.builtInComparators[thresholdComparator].requiredValues)) {
    errors.threshold1.push(_i18n.i18n.translate('xpack.stackAlerts.threshold.ui.validation.error.requiredThreshold1Text', {
      defaultMessage: 'Threshold1 is required.'
    }));
  }
  if (threshold && threshold.length === 2 && threshold[0] > threshold[1]) {
    errors.threshold1.push(_i18n.i18n.translate('xpack.stackAlerts.threshold.ui.validation.error.greaterThenThreshold0Text', {
      defaultMessage: 'Threshold1 should be > Threshold0.'
    }));
  }
  return validationResult;
};
exports.validateExpression = validateExpression;