"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SLOPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _public = require("@kbn/core/public");
var _serverRouteRepositoryClient = require("@kbn/server-route-repository-client");
var _react = require("react");
var _rxjs = require("rxjs");
var _common = require("../common");
var _paths = require("../common/locators/paths");
var _constants = require("./embeddable/slo/alerts/constants");
var _constants2 = require("./embeddable/slo/burn_rate/constants");
var _constants3 = require("./embeddable/slo/error_budget/constants");
var _constants4 = require("./embeddable/slo/overview/constants");
var _slo_details = require("./locators/slo_details");
var _slo_edit = require("./locators/slo_edit");
var _slo_list = require("./locators/slo_list");
var _register_burn_rate_rule_type = require("./rules/register_burn_rate_rule_type");
var _get_lazy_with_context_providers = require("./utils/get_lazy_with_context_providers");
var _register_ui_actions = require("./ui_actions/register_ui_actions");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class SLOPlugin {
  constructor(initContext) {
    var _this$initContext$con;
    (0, _defineProperty2.default)(this, "appUpdater$", new _rxjs.BehaviorSubject(() => ({})));
    (0, _defineProperty2.default)(this, "experimentalFeatures", {
      ruleFormV2: {
        enabled: false
      }
    });
    this.initContext = initContext;
    this.experimentalFeatures = (_this$initContext$con = this.initContext.config.get().experimental) !== null && _this$initContext$con !== void 0 ? _this$initContext$con : this.experimentalFeatures;
  }
  setup(core, plugins) {
    const kibanaVersion = this.initContext.env.packageInfo.version;
    const sloClient = (0, _serverRouteRepositoryClient.createRepositoryClient)(core);
    const sloDetailsLocator = plugins.share.url.locators.create(new _slo_details.SloDetailsLocatorDefinition());
    const sloEditLocator = plugins.share.url.locators.create(new _slo_edit.SloEditLocatorDefinition());
    const sloListLocator = plugins.share.url.locators.create(new _slo_list.SloListLocatorDefinition());
    const mount = async params => {
      const {
        renderApp
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./application')));
      const [coreStart, pluginsStart] = await core.getStartServices();
      const {
        observabilityRuleTypeRegistry
      } = pluginsStart.observability;
      return renderApp({
        appMountParameters: params,
        core: coreStart,
        isDev: this.initContext.env.mode.dev,
        observabilityRuleTypeRegistry,
        kibanaVersion,
        usageCollection: plugins.usageCollection,
        ObservabilityPageTemplate: pluginsStart.observabilityShared.navigation.PageTemplate,
        plugins: pluginsStart,
        isServerless: !!pluginsStart.serverless,
        experimentalFeatures: this.experimentalFeatures,
        sloClient
      });
    };
    const appUpdater$ = this.appUpdater$;
    const app = {
      id: _common.sloAppId,
      title: _common.PLUGIN_NAME,
      order: 8002,
      updater$: appUpdater$,
      euiIconType: 'logoObservability',
      appRoute: _paths.SLOS_BASE_PATH,
      category: _public.DEFAULT_APP_CATEGORIES.observability,
      mount,
      keywords: ['observability', 'monitor', 'slos']
    };
    // Register an application into the side navigation menu
    core.application.register(app);
    const registerRules = async () => {
      const [coreStart, pluginsStart] = await core.getStartServices();
      const lazyWithContextProviders = (0, _get_lazy_with_context_providers.getLazyWithContextProviders)({
        core: coreStart,
        isDev: this.initContext.env.mode.dev,
        kibanaVersion,
        observabilityRuleTypeRegistry: pluginsStart.observability.observabilityRuleTypeRegistry,
        ObservabilityPageTemplate: pluginsStart.observabilityShared.navigation.PageTemplate,
        plugins: pluginsStart,
        isServerless: !!plugins.serverless,
        experimentalFeatures: this.experimentalFeatures,
        sloClient
      });
      (0, _register_burn_rate_rule_type.registerBurnRateRuleType)(plugins.observability.observabilityRuleTypeRegistry, lazyWithContextProviders);
    };
    registerRules();
    const registerEmbeddables = async () => {
      const licensing = plugins.licensing;
      const license = await (0, _rxjs.firstValueFrom)(licensing.license$);
      const hasPlatinumLicense = license.hasAtLeast('platinum');
      if (hasPlatinumLicense) {
        const [coreStart, pluginsStart] = await core.getStartServices();
        pluginsStart.dashboard.registerDashboardPanelPlacementSetting(_constants4.SLO_OVERVIEW_EMBEDDABLE_ID, serializedState => {
          var _serializedState$rawS, _serializedState$rawS2;
          if (serializedState !== null && serializedState !== void 0 && (_serializedState$rawS = serializedState.rawState) !== null && _serializedState$rawS !== void 0 && _serializedState$rawS.showAllGroupByInstances || serializedState !== null && serializedState !== void 0 && (_serializedState$rawS2 = serializedState.rawState) !== null && _serializedState$rawS2 !== void 0 && _serializedState$rawS2.groupFilters) {
            return {
              width: 24,
              height: 8
            };
          }
          return {
            width: 12,
            height: 8
          };
        });
        pluginsStart.dashboard.registerDashboardPanelPlacementSetting(_constants2.SLO_BURN_RATE_EMBEDDABLE_ID, () => {
          return {
            width: 14,
            height: 7
          };
        });
        plugins.embeddable.registerReactEmbeddableFactory(_constants4.SLO_OVERVIEW_EMBEDDABLE_ID, async () => {
          const {
            getOverviewEmbeddableFactory
          } = await Promise.resolve().then(() => _interopRequireWildcard(require('./embeddable/slo/overview/slo_embeddable_factory')));
          return getOverviewEmbeddableFactory({
            coreStart,
            pluginsStart,
            sloClient
          });
        });
        plugins.embeddable.registerReactEmbeddableFactory(_constants.SLO_ALERTS_EMBEDDABLE_ID, async () => {
          const {
            getAlertsEmbeddableFactory
          } = await Promise.resolve().then(() => _interopRequireWildcard(require('./embeddable/slo/alerts/slo_alerts_embeddable_factory')));
          return getAlertsEmbeddableFactory({
            coreStart,
            pluginsStart,
            sloClient,
            kibanaVersion
          });
        });
        plugins.embeddable.registerReactEmbeddableFactory(_constants3.SLO_ERROR_BUDGET_ID, async () => {
          const {
            getErrorBudgetEmbeddableFactory
          } = await Promise.resolve().then(() => _interopRequireWildcard(require('./embeddable/slo/error_budget/error_budget_react_embeddable_factory')));
          return getErrorBudgetEmbeddableFactory({
            coreStart,
            pluginsStart,
            sloClient
          });
        });
        plugins.embeddable.registerReactEmbeddableFactory(_constants2.SLO_BURN_RATE_EMBEDDABLE_ID, async () => {
          const {
            getBurnRateEmbeddableFactory
          } = await Promise.resolve().then(() => _interopRequireWildcard(require('./embeddable/slo/burn_rate/burn_rate_react_embeddable_factory')));
          return getBurnRateEmbeddableFactory({
            coreStart,
            pluginsStart,
            sloClient
          });
        });
        (0, _register_ui_actions.registerSloUiActions)(plugins.uiActions, coreStart, pluginsStart, sloClient);
      }
    };
    registerEmbeddables();
    return {
      sloDetailsLocator,
      sloEditLocator,
      sloListLocator
    };
  }
  start(core, plugins) {
    const kibanaVersion = this.initContext.env.packageInfo.version;
    const sloClient = (0, _serverRouteRepositoryClient.createRepositoryClient)(core);
    const lazyWithContextProviders = (0, _get_lazy_with_context_providers.getLazyWithContextProviders)({
      core,
      isDev: this.initContext.env.mode.dev,
      kibanaVersion,
      observabilityRuleTypeRegistry: plugins.observability.observabilityRuleTypeRegistry,
      ObservabilityPageTemplate: plugins.observabilityShared.navigation.PageTemplate,
      plugins,
      isServerless: !!plugins.serverless,
      experimentalFeatures: this.experimentalFeatures,
      sloClient
    });
    const getCreateSLOFlyout = lazyWithContextProviders(/*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./pages/slo_edit/shared_flyout/slo_add_form_flyout')))), {
      spinnerSize: 'm'
    });
    plugins.discoverShared.features.registry.register({
      id: 'observability-create-slo',
      createSLOFlyout: getCreateSLOFlyout
    });
    return {
      getCreateSLOFlyout
    };
  }
  stop() {}
}
exports.SLOPlugin = SLOPlugin;