"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchSLOSuggestions = useFetchSLOSuggestions;
var _reactQuery = require("@kbn/react-query");
var _use_plugin_context = require("../../../hooks/use_plugin_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useFetchSLOSuggestions() {
  const {
    sloClient
  } = (0, _use_plugin_context.usePluginContext)();
  const {
    isLoading,
    isError,
    isSuccess,
    data
  } = (0, _reactQuery.useQuery)({
    queryKey: ['fetchSLOSuggestions'],
    queryFn: async ({
      signal
    }) => {
      try {
        return await sloClient.fetch('GET /internal/observability/slos/suggestions', {
          signal
        });
      } catch (error) {
        // ignore error
      }
    },
    refetchOnWindowFocus: false,
    keepPreviousData: true
  });
  return {
    suggestions: data,
    isLoading,
    isSuccess,
    isError
  };
}