"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HistoricalDataCharts = HistoricalDataCharts;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _use_fetch_historical_summary = require("../../../hooks/use_fetch_historical_summary");
var _chart_data_formatter = require("../../../utils/slo/chart_data_formatter");
var _error_budget_chart_panel = require("./error_budget_chart_panel");
var _sli_chart_panel = require("./sli_chart_panel");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function HistoricalDataCharts({
  slo,
  range,
  isAutoRefreshing,
  hideMetadata = false,
  onBrushed
}) {
  const {
    data: historicalSummaries = [],
    isLoading
  } = (0, _use_fetch_historical_summary.useFetchHistoricalSummary)({
    sloList: [slo],
    shouldRefetch: isAutoRefreshing,
    range
  });
  const sloHistoricalSummary = historicalSummaries.find(historicalSummary => historicalSummary.sloId === slo.id && historicalSummary.instanceId === slo.instanceId);
  const errorBudgetBurnDownData = (0, _chart_data_formatter.formatHistoricalData)(sloHistoricalSummary === null || sloHistoricalSummary === void 0 ? void 0 : sloHistoricalSummary.data, 'error_budget_remaining');
  const historicalSliData = (0, _chart_data_formatter.formatHistoricalData)(sloHistoricalSummary === null || sloHistoricalSummary === void 0 ? void 0 : sloHistoricalSummary.data, 'sli_value');
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_sli_chart_panel.SliChartPanel, {
    data: historicalSliData,
    isLoading: isLoading,
    slo: slo,
    hideMetadata: hideMetadata,
    onBrushed: onBrushed
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_error_budget_chart_panel.ErrorBudgetChartPanel, {
    data: errorBudgetBurnDownData,
    isLoading: isLoading,
    slo: slo,
    hideMetadata: hideMetadata,
    onBrushed: onBrushed
  })));
}