"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionModalProvider = ActionModalProvider;
exports.useActionModal = useActionModal;
var _react = _interopRequireWildcard(require("react"));
var _bulk_delete_confirmation_modal = require("../components/slo/bulk_delete_confirmation_modal/bulk_delete_confirmation_modal");
var _slo_delete_confirmation_modal = require("../components/slo/delete_confirmation_modal/slo_delete_confirmation_modal");
var _slo_disable_confirmation_modal = require("../components/slo/disable_confirmation_modal/slo_disable_confirmation_modal");
var _slo_enable_confirmation_modal = require("../components/slo/enable_confirmation_modal/slo_enable_confirmation_modal");
var _slo_reset_confirmation_modal = require("../components/slo/reset_confirmation_modal/slo_reset_confirmation_modal");
var _use_clone_slo = require("../hooks/use_clone_slo");
var _bulk_purge_modal_container = require("../components/slo/purge_confirmation_modal/bulk_purge_modal_container");
var _purge_modal_container = require("../components/slo/purge_confirmation_modal/purge_modal_container");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ActionModalContext = /*#__PURE__*/(0, _react.createContext)(undefined);
function ActionModalProvider({
  children
}) {
  const [action, triggerAction] = (0, _react.useState)();
  const navigateToClone = (0, _use_clone_slo.useCloneSlo)();
  function handleOnCancel() {
    var _action$onCancel;
    triggerAction(undefined);
    action === null || action === void 0 ? void 0 : (_action$onCancel = action.onCancel) === null || _action$onCancel === void 0 ? void 0 : _action$onCancel.call(action);
  }
  function handleOnConfirm() {
    var _action$onConfirm;
    triggerAction(undefined);
    action === null || action === void 0 ? void 0 : (_action$onConfirm = action.onConfirm) === null || _action$onConfirm === void 0 ? void 0 : _action$onConfirm.call(action);
  }
  function handleAction() {
    switch (action === null || action === void 0 ? void 0 : action.type) {
      case 'clone':
        navigateToClone(action.item);
        return;
      case 'delete':
        return /*#__PURE__*/_react.default.createElement(_slo_delete_confirmation_modal.SloDeleteConfirmationModal, {
          slo: action.item,
          onCancel: handleOnCancel,
          onConfirm: handleOnConfirm
        });
      case 'reset':
        return /*#__PURE__*/_react.default.createElement(_slo_reset_confirmation_modal.SloResetConfirmationModal, {
          slo: action.item,
          onCancel: handleOnCancel,
          onConfirm: handleOnConfirm
        });
      case 'enable':
        return /*#__PURE__*/_react.default.createElement(_slo_enable_confirmation_modal.SloEnableConfirmationModal, {
          slo: action.item,
          onCancel: handleOnCancel,
          onConfirm: handleOnConfirm
        });
      case 'disable':
        return /*#__PURE__*/_react.default.createElement(_slo_disable_confirmation_modal.SloDisableConfirmationModal, {
          slo: action.item,
          onCancel: handleOnCancel,
          onConfirm: handleOnConfirm
        });
      case 'purge':
        return /*#__PURE__*/_react.default.createElement(_purge_modal_container.PurgeConfirmationContainer, {
          item: action.item,
          onCancel: handleOnCancel,
          onConfirm: handleOnConfirm
        });
      case 'bulk_delete':
        return /*#__PURE__*/_react.default.createElement(_bulk_delete_confirmation_modal.SloBulkDeleteConfirmationModal, {
          items: action.items,
          onCancel: handleOnCancel,
          onConfirm: handleOnConfirm
        });
      case 'bulk_purge':
        return /*#__PURE__*/_react.default.createElement(_bulk_purge_modal_container.BulkPurgeConfirmationContainer, {
          items: action.items,
          onCancel: handleOnCancel,
          onConfirm: handleOnConfirm
        });
      default:
        return null;
    }
  }
  return /*#__PURE__*/_react.default.createElement(ActionModalContext.Provider, {
    value: {
      triggerAction
    }
  }, children, handleAction());
}
function useActionModal() {
  const context = (0, _react.useContext)(ActionModalContext);
  if (!context) {
    throw new Error('useActionModal must be used within an ActionModalProvider');
  }
  return context;
}