"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VIEW_MODE_TOGGLE = exports.INVESTIGATED_ALERT_TEST_ID = exports.DetailPanelAlertTab = exports.ALERTS_TAB_EMPTY_STATE_TEST_ID = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _lodash = require("lodash");
var _styles = require("./styles");
var _detail_panel_alert_list_item = require("../detail_panel_alert_list_item");
var _detail_panel_alert_group_item = require("../detail_panel_alert_group_item");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ALERTS_TAB_EMPTY_STATE_TEST_ID = exports.ALERTS_TAB_EMPTY_STATE_TEST_ID = 'sessionView:detailPanelAlertsEmptyState';
const INVESTIGATED_ALERT_TEST_ID = exports.INVESTIGATED_ALERT_TEST_ID = 'sessionView:detailPanelInvestigatedAlert';
const VIEW_MODE_TOGGLE = exports.VIEW_MODE_TOGGLE = 'sessionView:detailPanelAlertsViewMode';
const VIEW_MODE_LIST = 'listView';
const VIEW_MODE_GROUP = 'groupView';

/**
 * Host Panel of  session view detail panel.
 */
const DetailPanelAlertTab = ({
  alerts,
  isFetchingAlerts,
  hasNextPageAlerts,
  fetchNextPageAlerts,
  onJumpToEvent,
  onShowAlertDetails,
  investigatedAlertId
}) => {
  const styles = (0, _styles.useStyles)();
  const [viewMode, setViewMode] = (0, _react.useState)(VIEW_MODE_LIST);
  const viewModes = [{
    id: VIEW_MODE_LIST,
    label: _i18n.i18n.translate('xpack.sessionView.alertDetailsTab.listView', {
      defaultMessage: 'List view'
    })
  }, {
    id: VIEW_MODE_GROUP,
    label: _i18n.i18n.translate('xpack.sessionView.alertDetailsTab.groupView', {
      defaultMessage: 'Group view'
    })
  }];
  const investigatedAlert = (0, _react.useMemo)(() => {
    return investigatedAlertId && alerts.find(event => {
      var _event$kibana, _event$kibana$alert;
      return ((_event$kibana = event.kibana) === null || _event$kibana === void 0 ? void 0 : (_event$kibana$alert = _event$kibana.alert) === null || _event$kibana$alert === void 0 ? void 0 : _event$kibana$alert.uuid) === investigatedAlertId;
    });
  }, [investigatedAlertId, alerts]);
  const groupedAlerts = (0, _react.useMemo)(() => {
    return (0, _lodash.groupBy)(alerts, event => {
      var _event$kibana2, _event$kibana2$alert, _event$kibana2$alert$;
      return (_event$kibana2 = event.kibana) === null || _event$kibana2 === void 0 ? void 0 : (_event$kibana2$alert = _event$kibana2.alert) === null || _event$kibana2$alert === void 0 ? void 0 : (_event$kibana2$alert$ = _event$kibana2$alert.rule) === null || _event$kibana2$alert$ === void 0 ? void 0 : _event$kibana2$alert$.uuid;
    });
  }, [alerts]);
  if (alerts.length === 0) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      "data-test-subj": ALERTS_TAB_EMPTY_STATE_TEST_ID,
      title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.sessionView.detailPanelAlertsEmptyTitle",
        defaultMessage: "No alerts"
      })),
      body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.sessionView.detailPanelAlertsEmptyMsg",
        defaultMessage: "No alerts were created for this session."
      }))
    });
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    css: styles.container
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    "data-test-subj": VIEW_MODE_TOGGLE,
    legend: _i18n.i18n.translate('xpack.sessionView.alertDetailsTab.toggleViewMode', {
      defaultMessage: 'Toggle view mode'
    }),
    options: viewModes,
    idSelected: viewMode,
    onChange: setViewMode,
    buttonSize: "compressed",
    isFullWidth: true
  }), investigatedAlert && /*#__PURE__*/_react.default.createElement("div", {
    css: styles.stickyItem,
    "data-test-subj": INVESTIGATED_ALERT_TEST_ID
  }, /*#__PURE__*/_react.default.createElement(_detail_panel_alert_list_item.DetailPanelAlertListItem, {
    event: investigatedAlert,
    onJumpToEvent: onJumpToEvent,
    onShowAlertDetails: onShowAlertDetails,
    isInvestigated: true
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m",
    size: "full"
  })), viewMode === VIEW_MODE_LIST ? alerts.map(event => {
    var _event$kibana3, _event$kibana3$alert;
    const key = (_event$kibana3 = event.kibana) === null || _event$kibana3 === void 0 ? void 0 : (_event$kibana3$alert = _event$kibana3.alert) === null || _event$kibana3$alert === void 0 ? void 0 : _event$kibana3$alert.uuid;
    if (key && event !== investigatedAlert) {
      return /*#__PURE__*/_react.default.createElement(_detail_panel_alert_list_item.DetailPanelAlertListItem, {
        key: key,
        event: event,
        onJumpToEvent: onJumpToEvent,
        onShowAlertDetails: onShowAlertDetails
      });
    }
  }) : Object.keys(groupedAlerts).map(ruleId => {
    var _alertsByRule$0$kiban, _alertsByRule$0$kiban2, _alertsByRule$0$kiban3;
    const alertsByRule = groupedAlerts[ruleId];
    const key = (_alertsByRule$0$kiban = alertsByRule[0].kibana) === null || _alertsByRule$0$kiban === void 0 ? void 0 : (_alertsByRule$0$kiban2 = _alertsByRule$0$kiban.alert) === null || _alertsByRule$0$kiban2 === void 0 ? void 0 : (_alertsByRule$0$kiban3 = _alertsByRule$0$kiban2.rule) === null || _alertsByRule$0$kiban3 === void 0 ? void 0 : _alertsByRule$0$kiban3.uuid;
    if (key) {
      return /*#__PURE__*/_react.default.createElement(_detail_panel_alert_group_item.DetailPanelAlertGroupItem, {
        key: key,
        alerts: alertsByRule,
        onJumpToEvent: onJumpToEvent,
        onShowAlertDetails: onShowAlertDetails
      });
    }
  }), hasNextPageAlerts && /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    isLoading: isFetchingAlerts,
    onClick: fetchNextPageAlerts,
    css: styles.loadMoreBtn,
    "data-test-subj": "alerts-details-load-more"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.sessionView.alertsLoadMoreButton",
    defaultMessage: "Load more alerts"
  })));
};
exports.DetailPanelAlertTab = DetailPanelAlertTab;