"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServerlessPlugin = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _react = _interopRequireDefault(require("react"));
var _navigation = require("./navigation");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ServerlessPlugin {
  constructor() {}
  setup(_core, _dependencies) {
    return {};
  }
  start(core, dependencies) {
    const {
      chrome,
      rendering
    } = core;

    // Casting the "chrome.project" service to an "internal" type: this is intentional to obscure the property from Typescript.
    const {
      project
    } = chrome;
    const {
      cloud
    } = dependencies;
    chrome.setChromeStyle('project');
    if (cloud.serverless.projectName) {
      project.setProjectName(cloud.serverless.projectName);
    }
    project.setCloudUrls(cloud);
    const activeNavigationNodes$ = project.getActiveNavigationNodes$();
    const navigationTreeUi$ = project.getNavigationTreeUi$();
    chrome.navControls.registerRight({
      order: 1,
      mount: (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        href: "https://ela.st/serverless-feedback",
        size: 's',
        color: 'warning',
        iconType: 'popout',
        iconSide: 'right',
        target: '_blank'
      }, _i18n.i18n.translate('xpack.serverless.header.giveFeedbackBtn.label', {
        defaultMessage: 'Give feedback'
      })), rendering)
    });
    return {
      setSideNavComponentDeprecated: sideNavigationComponent => project.setSideNavComponent(sideNavigationComponent),
      initNavigation: (id, navigationTree$, {
        dataTestSubj
      } = {}) => {
        project.initNavigation(id, navigationTree$);
        project.setSideNavComponent(() => /*#__PURE__*/_react.default.createElement(_navigation.SideNavComponent, {
          navProps: {
            navigationTree$: navigationTreeUi$,
            dataTestSubj
          },
          deps: {
            core,
            activeNodes$: activeNavigationNodes$
          }
        }));
      },
      setBreadcrumbs: (breadcrumbs, params) => project.setBreadcrumbs(breadcrumbs, params),
      setProjectHome: homeHref => project.setHome(homeHref),
      getNavigationCards: (roleManagementEnabled, extendCardNavDefinitions) => {
        if (!roleManagementEnabled) return extendCardNavDefinitions;
        const manageOrgMembersNavCard = (0, _navigation.generateManageOrgMembersNavCard)(cloud.usersAndRolesUrl);
        if (extendCardNavDefinitions) {
          extendCardNavDefinitions[_navigation.manageOrgMembersNavCardName] = manageOrgMembersNavCard;
          return extendCardNavDefinitions;
        }
        return {
          [_navigation.manageOrgMembersNavCardName]: manageOrgMembersNavCard
        };
      }
    };
  }
  stop() {}
}
exports.ServerlessPlugin = ServerlessPlugin;