"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.allHosts = void 0;
exports.getHostCriticalityData = getHostCriticalityData;
exports.getHostRiskData = getHostRiskData;
var _fp = require("lodash/fp");
var _lodash = _interopRequireDefault(require("lodash"));
var _constants = require("../../../../../../common/constants");
var _search_strategy = require("../../../../../../common/search_strategy");
var _build_query = require("../../../../../utils/build_query");
var _queryAll_hosts = require("./query.all_hosts.dsl");
var _helpers = require("./helpers");
var _queryRisk_score = require("../../risk_score/all/query.risk_score.dsl");
var _queryAsset_criticality = require("../../asset_criticality/query.asset_criticality.dsl");
var _asset_criticality = require("../../../../../../common/entity_analytics/asset_criticality");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const allHosts = exports.allHosts = {
  buildDsl: options => {
    if (options.pagination && options.pagination.querySize >= _constants.DEFAULT_MAX_TABLE_QUERY_SIZE) {
      throw new Error(`No query size above ${_constants.DEFAULT_MAX_TABLE_QUERY_SIZE}`);
    }
    return (0, _queryAll_hosts.buildHostsQuery)(options);
  },
  parse: async (options, response, deps) => {
    const {
      activePage,
      cursorStart,
      fakePossibleCount,
      querySize
    } = options.pagination;
    const totalCount = (0, _fp.getOr)(0, 'aggregations.host_count.value', response.rawResponse);
    const buckets = (0, _fp.getOr)([], 'aggregations.host_data.buckets', response.rawResponse);
    const hostsEdges = buckets.map(bucket => (0, _helpers.formatHostEdgesData)(_helpers.HOSTS_FIELDS, bucket));
    const fakeTotalCount = fakePossibleCount <= totalCount ? fakePossibleCount : totalCount;
    const edges = hostsEdges.splice(cursorStart, querySize - cursorStart);
    const inspect = {
      dsl: [(0, _build_query.inspectStringifyObject)((0, _queryAll_hosts.buildHostsQuery)(options))]
    };
    const showMorePagesIndicator = totalCount > fakeTotalCount;
    const hostNames = edges.map(edge => (0, _fp.getOr)('', 'node.host.name[0]', edge));
    const enhancedEdges = deps !== null && deps !== void 0 && deps.spaceId ? await enhanceEdges(edges, hostNames, deps.spaceId, deps.esClient) : edges;
    return {
      ...response,
      inspect,
      edges: enhancedEdges,
      totalCount,
      pageInfo: {
        activePage: activePage !== null && activePage !== void 0 ? activePage : 0,
        fakeTotalCount,
        showMorePagesIndicator
      }
    };
  }
};
async function enhanceEdges(edges, hostNames, spaceId, esClient) {
  const [riskByHostName, criticalityByHostName] = await Promise.all([getHostRiskData(esClient, spaceId, hostNames).then(buildRecordFromAggs('host.name', 'host.risk.calculated_level')), getHostCriticalityData(esClient, hostNames).then(buildRecordFromAggs('id_value', 'criticality_level'))]);
  return edges.map(({
    node,
    cursor
  }) => {
    var _node$_id, _node$_id2;
    return {
      node: {
        ...node,
        risk: riskByHostName === null || riskByHostName === void 0 ? void 0 : riskByHostName[(_node$_id = node._id) !== null && _node$_id !== void 0 ? _node$_id : ''],
        criticality: criticalityByHostName === null || criticalityByHostName === void 0 ? void 0 : criticalityByHostName[(_node$_id2 = node._id) !== null && _node$_id2 !== void 0 ? _node$_id2 : '']
      },
      cursor
    };
  });
}
async function getHostRiskData(esClient, spaceId, hostNames) {
  try {
    const hostRiskResponse = await esClient.asCurrentUser.search((0, _queryRisk_score.buildRiskScoreQuery)({
      defaultIndex: [(0, _search_strategy.getRiskIndex)(spaceId, true)],
      filterQuery: (0, _search_strategy.buildHostNamesFilter)(hostNames),
      riskScoreEntity: _search_strategy.EntityType.host
    }));
    return hostRiskResponse;
  } catch (error) {
    var _error$meta, _error$meta$body, _error$meta$body$erro;
    if ((error === null || error === void 0 ? void 0 : (_error$meta = error.meta) === null || _error$meta === void 0 ? void 0 : (_error$meta$body = _error$meta.body) === null || _error$meta$body === void 0 ? void 0 : (_error$meta$body$erro = _error$meta$body.error) === null || _error$meta$body$erro === void 0 ? void 0 : _error$meta$body$erro.type) !== 'index_not_found_exception') {
      throw error;
    }
    return undefined;
  }
}
async function getHostCriticalityData(esClient, hostNames) {
  try {
    const criticalityResponse = await esClient.asCurrentUser.search((0, _queryAsset_criticality.buildAssetCriticalityQuery)({
      defaultIndex: [(0, _asset_criticality.getAssetCriticalityIndex)('default')],
      // TODO:(@tiansivive) move to constant or import from somewhere else
      filterQuery: {
        terms: {
          id_value: hostNames
        }
      }
    }));
    return criticalityResponse;
  } catch (error) {
    var _error$meta2, _error$meta2$body, _error$meta2$body$err;
    if ((error === null || error === void 0 ? void 0 : (_error$meta2 = error.meta) === null || _error$meta2 === void 0 ? void 0 : (_error$meta2$body = _error$meta2.body) === null || _error$meta2$body === void 0 ? void 0 : (_error$meta2$body$err = _error$meta2$body.error) === null || _error$meta2$body$err === void 0 ? void 0 : _error$meta2$body$err.type) !== 'index_not_found_exception') {
      throw error;
    }
    return undefined;
  }
}
const buildRecordFromAggs = (key, path) => data => data === null || data === void 0 ? void 0 : data.hits.hits.reduce((acc, hit) => ({
  ...acc,
  [_lodash.default.get(hit._source, key) || '']: _lodash.default.get(hit._source, path)
}), {});