"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.enableAssetInventoryRoute = void 0;
var _utils = require("@kbn/lists-plugin/server/routes/utils");
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _zodHelpers = require("@kbn/zod-helpers");
var _constants = require("../../../../common/constants");
var _enable = require("../../../../common/api/entity_analytics/entity_store/enable.gen");
var _constants2 = require("../../../../common/api/asset_inventory/constants");
var _check_and_init_asset_criticality_resources = require("../../entity_analytics/asset_criticality/check_and_init_asset_criticality_resources");
var _errors = require("../errors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const enableAssetInventoryRoute = (router, logger) => {
  router.versioned.post({
    access: 'public',
    path: _constants2.ASSET_INVENTORY_ENABLE_API_PATH,
    security: {
      authz: {
        requiredPrivileges: ['securitySolution']
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: {
        body: (0, _zodHelpers.buildRouteValidationWithZod)(_enable.InitEntityStoreRequestBody)
      }
    }
  }, async (context, request, response) => {
    const siemResponse = (0, _utils.buildSiemResponse)(response);
    try {
      // Criticality resources are required by the Entity Store transforms
      await (0, _check_and_init_asset_criticality_resources.checkAndInitAssetCriticalityResources)(context, logger);
      const secSol = await context.securitySolution;
      const body = await secSol.getAssetInventoryClient().enable(secSol, request.body);
      return response.ok({
        body
      });
    } catch (e) {
      if (e instanceof Error && e.message === 'uiSetting') {
        return (0, _errors.errorInactiveFeature)(response);
      }
      const error = (0, _securitysolutionEsUtils.transformError)(e);
      logger.error(`Error initializing asset inventory: ${error.message}`);
      return siemResponse.error({
        statusCode: error.statusCode,
        body: error.message
      });
    }
  });
};
exports.enableAssetInventoryRoute = enableAssetInventoryRoute;