"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getGenerateEsqlGraph = void 0;
var _langgraph = require("@langchain/langgraph");
var _prebuilt = require("@langchain/langgraph/prebuilt");
var _state = require("./state");
var _step_router = require("./step_router");
var _nl_to_esql_agent = require("./nodes/nl_to_esql_agent/nl_to_esql_agent");
var _validate_esql_in_last_message_node = require("./nodes/validate_esql_in_last_message_node/validate_esql_in_last_message_node");
var _inspect_index_mapping_tool = require("../../tools/inspect_index_mapping_tool/inspect_index_mapping_tool");
var _constants = require("./constants");
var _build_error_report_from_last_message = require("./nodes/build_error_report_from_last_message/build_error_report_from_last_message");
var _build_success_report_from_last_message = require("./nodes/build_success_report_from_last_message/build_success_report_from_last_message");
var _nl_to_esql_agent_without_validation = require("./nodes/nl_to_esql_agent_without_validation/nl_to_esql_agent_without_validation");
var _build_unvalidated_report_from_last_message = require("./nodes/build_unvalidated_report_from_last_message/build_unvalidated_report_from_last_message");
var _select_index_pattern = require("./nodes/select_index_pattern/select_index_pattern");
var _select_index_pattern2 = require("../select_index_pattern/select_index_pattern");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getGenerateEsqlGraph = async ({
  esClient,
  connectorId,
  inference,
  logger,
  request,
  createLlmInstance
}) => {
  const nlToEsqlAgentNode = (0, _nl_to_esql_agent.getNlToEsqlAgent)({
    connectorId,
    inference,
    logger,
    request,
    tools: [(0, _inspect_index_mapping_tool.getInspectIndexMappingTool)({
      esClient,
      indexPattern: 'placeholder'
    })]
  });
  const nlToEsqlAgentWithoutValidationNode = (0, _nl_to_esql_agent_without_validation.getNlToEsqlAgentWithoutValidation)({
    connectorId,
    inference,
    logger,
    request
  });
  const validateEsqlInLastMessageNode = (0, _validate_esql_in_last_message_node.getValidateEsqlInLastMessageNode)({
    esClient
  });
  const buildErrorReportFromLastMessageNode = (0, _build_error_report_from_last_message.getBuildErrorReportFromLastMessageNode)();
  const buildSuccessReportFromLastMessageNode = (0, _build_success_report_from_last_message.getBuildSuccessReportFromLastMessageNode)();
  const buildUnvalidatedReportFromLastMessageNode = (0, _build_unvalidated_report_from_last_message.getBuildUnvalidatedReportFromLastMessageNode)();
  const identifyIndexGraph = await (0, _select_index_pattern2.getSelectIndexPatternGraph)({
    esClient,
    createLlmInstance
  });
  const selectIndexPatternSubGraph = (0, _select_index_pattern.getSelectIndexPattern)({
    identifyIndexGraph
  });
  const graph = new _langgraph.StateGraph(_state.GenerateEsqlAnnotation)
  // Nodes
  .addNode(_constants.SELECT_INDEX_PATTERN_GRAPH, selectIndexPatternSubGraph, {
    subgraphs: [identifyIndexGraph]
  }).addNode(_constants.NL_TO_ESQL_AGENT_NODE, nlToEsqlAgentNode, {
    retryPolicy: {
      maxAttempts: 3
    }
  }).addNode(_constants.TOOLS_NODE, state => {
    const {
      selectedIndexPattern
    } = state;
    if (selectedIndexPattern == null) {
      throw new Error('Input is required');
    }
    const inspectIndexMappingTool = (0, _inspect_index_mapping_tool.getInspectIndexMappingTool)({
      esClient,
      indexPattern: selectedIndexPattern
    });
    const tools = [inspectIndexMappingTool];
    const toolNode = new _prebuilt.ToolNode(tools);
    return toolNode.invoke(state);
  }).addNode(_constants.VALIDATE_ESQL_FROM_LAST_MESSAGE_NODE, validateEsqlInLastMessageNode).addNode(_constants.BUILD_SUCCESS_REPORT_FROM_LAST_MESSAGE_NODE, buildSuccessReportFromLastMessageNode).addNode(_constants.BUILD_ERROR_REPORT_FROM_LAST_MESSAGE_NODE, buildErrorReportFromLastMessageNode).addNode(_constants.NL_TO_ESQL_AGENT_WITHOUT_VALIDATION_NODE, nlToEsqlAgentWithoutValidationNode).addNode(_constants.BUILD_UNVALIDATED_REPORT_FROM_LAST_MESSAGE_NODE, buildUnvalidatedReportFromLastMessageNode)

  // Edges
  .addEdge(_langgraph.START, _constants.SELECT_INDEX_PATTERN_GRAPH).addConditionalEdges(_constants.SELECT_INDEX_PATTERN_GRAPH, _step_router.selectIndexStepRouter, {
    [_constants.NL_TO_ESQL_AGENT_NODE]: _constants.NL_TO_ESQL_AGENT_NODE,
    [_langgraph.END]: _langgraph.END
  }).addConditionalEdges(_constants.NL_TO_ESQL_AGENT_NODE, _step_router.nlToEsqlAgentStepRouter, {
    [_constants.VALIDATE_ESQL_FROM_LAST_MESSAGE_NODE]: _constants.VALIDATE_ESQL_FROM_LAST_MESSAGE_NODE,
    [_constants.TOOLS_NODE]: _constants.TOOLS_NODE
  }).addConditionalEdges(_constants.VALIDATE_ESQL_FROM_LAST_MESSAGE_NODE, _step_router.validateEsqlFromLastMessageStepRouter, {
    [_constants.BUILD_SUCCESS_REPORT_FROM_LAST_MESSAGE_NODE]: _constants.BUILD_SUCCESS_REPORT_FROM_LAST_MESSAGE_NODE,
    [_constants.BUILD_ERROR_REPORT_FROM_LAST_MESSAGE_NODE]: _constants.BUILD_ERROR_REPORT_FROM_LAST_MESSAGE_NODE,
    [_constants.NL_TO_ESQL_AGENT_WITHOUT_VALIDATION_NODE]: _constants.NL_TO_ESQL_AGENT_WITHOUT_VALIDATION_NODE
  }).addEdge(_constants.TOOLS_NODE, _constants.NL_TO_ESQL_AGENT_NODE).addEdge(_constants.BUILD_ERROR_REPORT_FROM_LAST_MESSAGE_NODE, _constants.NL_TO_ESQL_AGENT_NODE).addEdge(_constants.BUILD_SUCCESS_REPORT_FROM_LAST_MESSAGE_NODE, _langgraph.END).addEdge(_constants.NL_TO_ESQL_AGENT_WITHOUT_VALIDATION_NODE, _constants.BUILD_UNVALIDATED_REPORT_FROM_LAST_MESSAGE_NODE).addEdge(_constants.BUILD_UNVALIDATED_REPORT_FROM_LAST_MESSAGE_NODE, _langgraph.END).compile();
  return graph;
};
exports.getGenerateEsqlGraph = getGenerateEsqlGraph;