"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EqlTabHeader = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _constants = require("../../../../../../common/store/inputs/constants");
var _timeline = require("../../../../../../../common/types/timeline");
var _exit_full_screen = require("../../../../../../common/components/exit_full_screen");
var _super_date_picker = require("../../../../../../common/components/super_date_picker");
var _model = require("../../../../../../sourcerer/store/model");
var _date_picker_lock = require("../../../date_picker_lock");
var _eql = require("../../../query_bar/eql");
var _components = require("../../../../../../sourcerer/components");
var _layout = require("../../shared/layout");
var _data_view_picker = require("../../../../../../data_view_manager/components/data_view_picker");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EqlTabHeader = exports.EqlTabHeader = /*#__PURE__*/(0, _react.memo)(({
  activeTab,
  setTimelineFullScreen,
  timelineFullScreen,
  timelineId,
  newDataViewPickerEnabled
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_layout.StyledEuiFlyoutHeader, {
  "data-test-subj": `${activeTab}-tab-flyout-header`,
  hasBorder: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  className: "euiScrollBar",
  alignItems: "flexStart",
  gutterSize: "s",
  "data-test-subj": "timeline-date-picker-container",
  responsive: false
}, timelineFullScreen && setTimelineFullScreen != null && /*#__PURE__*/_react.default.createElement(_exit_full_screen.ExitFullScreen, {
  fullScreen: timelineFullScreen,
  setFullScreen: setTimelineFullScreen
}), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, activeTab === _timeline.TimelineTabs.eql && (newDataViewPickerEnabled ? /*#__PURE__*/_react.default.createElement(_data_view_picker.DataViewPicker, {
  scope: _model.SourcererScopeName.timeline
}) : /*#__PURE__*/_react.default.createElement(_components.Sourcerer, {
  scope: _model.SourcererScopeName.timeline
}))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_super_date_picker.SuperDatePicker, {
  width: "auto",
  id: _constants.InputsModelId.timeline,
  timelineId: timelineId
})), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_date_picker_lock.TimelineDatePickerLock, null))))), /*#__PURE__*/_react.default.createElement(_layout.TabHeaderContainer, {
  "data-test-subj": "timelineHeader"
}, /*#__PURE__*/_react.default.createElement(_eql.EqlQueryBarTimeline, {
  timelineId: timelineId
}))));
EqlTabHeader.displayName = 'EqlTabHeader';